/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import simonton.core.Bot;
import simonton.core.BulletWrapper;
import simonton.dc.Cluster;
import simonton.dc.DCWave;
import simonton.dc.Distancer;
import simonton.dc.MyTree;
import simonton.guns.Gun;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;

public class DCGun
extends Gun {
    private static final int DIST = 0;
    private static final int LAT_V = 1;
    private static final int RET_V = 2;
    private static final int CHANGE_T0 = 3;
    private static final int WALL_F = 4;
    private static final int WALL_ANG_F = 5;
    private static final int DATA_SIZE = 6;
    private MyTree hitWaves = new MyTree(6, 8, 1.0, 500);
    private Collection flyingWaves;
    private final int clusterSize;
    private boolean tickWaves;
    private double lastSpeed;
    private int lastDChange;
    private int lastOrientation = 1;
    private DCWave nextWave;
    private double nextBulletPower;
    private double[] weights = new double[6];
    private Distancer distancer = new Distancer(){
        final DCGun this$0;
        {
            this.this$0 = DCGun.this;
        }

        @Override
        public double getDistance(double[] p1, double[] p2) {
            double distance = 0.0;
            int i = 6;
            while (--i >= 0) {
                distance += DCGun.this.weights[i] * Math.abs(p1[i] - p2[i]);
            }
            return distance;
        }
    };
    private double hitrate;
    private double shots;

    public DCGun(int clusterSize, int firstCutSize, boolean tickWaves) {
        this.clusterSize = clusterSize;
        this.tickWaves = tickWaves;
        int i = 6;
        while (--i >= 0) {
            this.weights[i] = 1.0;
        }
    }

    @Override
    public void run() {
        this.flyingWaves = new ArrayList();
        this.nextWave = null;
        this.lastDChange = 0;
        this.lastSpeed = 0.0;
        super.run();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.testFlyingWaves(e);
        BulletWrapper bullet = null;
        if (this.getGunTurnRemainingRadians() == 0.0) {
            bullet = this.setFireBulletWrapper(this.nextBulletPower);
        }
        if (this.nextWave != null && (this.getEnergy() > 0.0 && this.tickWaves || bullet != null)) {
            this.flyingWaves.add(this.nextWave);
        }
        this.chooseNextBulletPower(e);
        this.makeNextWave(e);
        double aimAngle = this.shouldAim() ? this.aim(e) : this.nextWave.angle;
        this.setTurnGunRightRadians(FastMath.normalize(aimAngle - this.getGunHeadingRadians()));
    }

    @Override
    public boolean shouldAim() {
        return super.shouldAim() && this.nextWave != null;
    }

    public void chooseNextBulletPower(ScannedRobotEvent e) {
        if (e.getDistance() < 120.0) {
            this.nextBulletPower = 3.0;
            return;
        }
        double myEnergy = this.getEnergy();
        double enemyEnergy = e.getEnergy();
        this.nextBulletPower = myEnergy < 5.0 ? 1.0 : (myEnergy < 15.0 && enemyEnergy > myEnergy ? 1.4 : (myEnergy < 25.0 && enemyEnergy > myEnergy || myEnergy < enemyEnergy - 20.0 ? 1.59 : (this.hitrate > 0.28 && this.getRoundNum() >= 2 ? 3.0 : (this.hitrate > 0.22 && this.getRoundNum() >= 2 || e.getDistance() < 250.0 ? 2.39 : 1.9))));
        this.nextBulletPower = Math.min(this.nextBulletPower, enemyEnergy / 4.0);
        this.nextBulletPower = Math.min(this.nextBulletPower, myEnergy);
    }

    public void rollHitrate(double value) {
        double oldWeight = Math.min(this.shots, 2500.0);
        this.hitrate = (this.hitrate * oldWeight + value) / (oldWeight + 1.0);
        this.shots += 1.0;
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.rollHitrate(1.0);
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        this.rollHitrate(0.0);
    }

    private double aim(ScannedRobotEvent e) {
        double tolerance = this.nextWave.getTolerance();
        return this.aim(this.nextWave.chooseCluster(this.clusterSize, this.hitWaves, this.distancer), tolerance, true);
    }

    private double aim(Collection population, double tolerance, boolean filterOutOfBounds) {
        Collection cluster = population;
        double bestGf = 0.7;
        double bestDensity = -1.0;
        for (DCWave testWave : cluster) {
            double testDensity = testWave.getDensityIn(cluster, tolerance);
            if (!(testDensity > bestDensity)) continue;
            bestDensity = testDensity;
            bestGf = testWave.gfHit;
        }
        return this.nextWave.getAngleForGf(bestGf);
    }

    private void makeNextWave(ScannedRobotEvent e) {
        int orientation = 0;
        double speed = Math.abs(e.getVelocity());
        if (speed != 0.0) {
            double relativeHeading = Util.getRelativeHeading(this, e);
            if (e.getVelocity() < 0.0 ^ speed < this.lastSpeed) {
                relativeHeading += Math.PI;
            }
            orientation = Double.compare(FastMath.normalize(relativeHeading), 0.0);
        }
        double fireSpeed = Util.getBulletSpeed(this.nextBulletPower);
        double distance = e.getDistance();
        int ticksToHit = (int)Math.ceil(distance / fireSpeed);
        if (orientation == 0) {
            orientation = this.lastOrientation;
        } else {
            if (orientation != this.lastOrientation) {
                this.lastDChange = (int)this.getTime();
            }
            this.lastOrientation = orientation;
        }
        this.lastSpeed = speed;
        double lateralVelocity = Util.getLateralVelocity(this, e);
        double lateralSpeed = (double)orientation * lateralVelocity;
        double unitMove = Math.atan2(1.0, distance);
        double futureSpeed = lateralSpeed;
        double zeroOffset = 0.0;
        int i = 0;
        while (i < ticksToHit) {
            if ((futureSpeed -= 2.0) <= 0.0) {
                zeroOffset += unitMove * (2.0 + futureSpeed);
                break;
            }
            zeroOffset += (double)orientation * unitMove * futureSpeed;
            ++i;
        }
        double gfZero = Util.getAbsoluteBearing(this, e) + zeroOffset;
        double gfOne = this.orbitalEscapeAngle(lateralSpeed, unitMove, ticksToHit) - zeroOffset;
        double gfNeg = this.orbitalEscapeAngle(-lateralSpeed, unitMove, ticksToHit) + zeroOffset;
        DCWave wave = new DCWave((Bot)this, orientation, fireSpeed, gfZero, gfOne, gfNeg, distance);
        double[] location = new double[6];
        location[1] = DCGun.encode(lateralSpeed, -8.0, 8.0);
        location[2] = DCGun.encode(Util.getRetreatingVelocity(this, e), -8.0, 8.0);
        location[0] = DCGun.encode(e.getDistance(), 36.0, Util.maxDistance);
        location[4] = DCGun.trimEncode(Util.wallDistance(orientation, this, e), gfOne);
        location[3] = DCGun.trimEncode(this.getTime() - (long)this.lastDChange, ticksToHit);
        double wallAngle = Util.wallAngle(orientation, this, e);
        location[5] = Double.isNaN(wallAngle) || location[4] == 1.0 ? DCGun.encode(1.0, 1.0) : DCGun.encode(wallAngle, 1.5707963267948966);
        wave.clusterPoint = new Cluster.Point(wave, location);
        this.nextWave = wave;
    }

    private static double trimEncode(double value, double min, double max) {
        return DCGun.encode(Math.min(Math.max(value, min), max), min, max);
    }

    private static double trimEncode(double value, double max) {
        return DCGun.encode(Math.min(value, max), max);
    }

    private static double encode(double value, double min, double max) {
        return DCGun.encode(value - min, max - min);
    }

    private static double encode(double value, double max) {
        if (value < -0.0 || value > max) {
            Util.log("%f > %f\n", new Object[]{value, max});
            throw new AssertionError();
        }
        return value / max;
    }

    private double orbitalEscapeAngle(double lateralSpeed, double unitMove, int ticksToHit) {
        double futureSpeed = lateralSpeed;
        double gfOne = 0.0;
        int i = 0;
        while (i < ticksToHit) {
            if (futureSpeed < 0.0) {
                futureSpeed += 1.0;
            }
            if ((futureSpeed += 1.0) > 8.0) {
                futureSpeed = 8.0;
            }
            gfOne += unitMove * futureSpeed;
            ++i;
        }
        return gfOne;
    }

    private void testFlyingWaves(ScannedRobotEvent e) {
        Location enemyP = Util.project(this, e);
        Iterator it = this.flyingWaves.iterator();
        while (it.hasNext()) {
            DCWave wave = (DCWave)it.next();
            if (!wave.willPass(enemyP)) continue;
            wave.logHit(enemyP);
            wave.cluster = null;
            this.addHitWave(wave);
            it.remove();
        }
    }

    private void addHitWave(DCWave wave) {
        this.hitWaves.add(wave.clusterPoint);
    }

    @Override
    public void onPaint(Graphics2D g) {
        for (DCWave wave : this.flyingWaves) {
            wave.onPaint(g);
        }
        super.onPaint(g);
    }

    @Override
    public void printStats() {
        super.printStats();
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
        Util.log("Skip at buffer size %d\n", new Object[]{this.hitWaves.size()});
    }
}

