/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800.modules;

import fowl3628800.Enemy;
import fowl3628800.EnemyManager;
import fowl3628800.ModularBot;
import fowl3628800.modules.Module;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseWheelEvent;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyEvent;
import robocode.MouseEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class SweepModule
implements Module {
    ModularBot bot;
    private int radarDirection = 1;
    static final long TIME_THRESHOLD = 16L;

    public SweepModule(ModularBot bot) {
        this.bot = bot;
    }

    private void sweep() {
        double maxBearingAbs = 0.0;
        double maxBearing = 0.0;
        int scannedBots = 0;
        Iterator iterator = EnemyManager.getInstance().getMapIterator();
        while (iterator.hasNext()) {
            Enemy tmp = (Enemy)iterator.next();
            if (tmp == null || this.bot.getTime() - tmp.getTime() > 16L) continue;
            double bearing = Utils.normalRelativeAngleDegrees((double)(this.bot.getHeading() + tmp.getBearing() - this.bot.getRadarHeading()));
            if (Math.abs(bearing) > maxBearingAbs) {
                maxBearingAbs = Math.abs(bearing);
                maxBearing = bearing;
            }
            ++scannedBots;
        }
        double radarTurn = 180 * this.radarDirection;
        if (scannedBots == this.bot.getOthers()) {
            radarTurn = maxBearing + Math.signum(maxBearing) * 22.5;
        }
        this.bot.setTurnRadarRight(radarTurn);
        this.radarDirection = (int)Math.signum(radarTurn);
    }

    @Override
    public void preRun() {
        this.bot.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this.bot));
        this.bot.setTurnRadarRight(360.0);
    }

    @Override
    public void run() {
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyManager.getInstance().log(e, this.bot);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        Enemy enemy = EnemyManager.getInstance().get(e.getName());
        double damage = Rules.getBulletDamage((double)e.getPower());
        enemy.setDamageDoneToMe(enemy.getDamageDoneToMe() + damage);
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof RadarTurnCompleteCondition) {
            this.sweep();
        }
    }

    @Override
    public void onDeath(DeathEvent e) {
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent event) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent e) {
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        Enemy enemy = EnemyManager.getInstance().get(e.getName());
        double damage = Rules.getBulletDamage((double)e.getBullet().getPower());
        enemy.setDamageDoneByMe(enemy.getDamageDoneByMe() + damage);
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent evnt) {
    }

    @Override
    public void onBulletMissed(BulletMissedEvent evnt) {
    }

    @Override
    public void onHitRobot(HitRobotEvent evnt) {
    }

    @Override
    public void onKeyPressed(KeyEvent e) {
    }

    @Override
    public void onKeyReleased(KeyEvent e) {
    }

    @Override
    public void onKeyTyped(KeyEvent e) {
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
    }

    @Override
    public void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void onMouseExited(MouseEvent e) {
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
    }

    @Override
    public void onMousePressed(MouseEvent e) {
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
    }

    @Override
    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void onPaint(Graphics2D g) {
        int d;
        int[] draw;
        Color c = g.getColor();
        Iterator iterator = EnemyManager.getInstance().getMapIterator();
        while (iterator.hasNext()) {
            Enemy tmp = (Enemy)iterator.next();
            g.setColor(tmp.isDead() ? Color.WHITE : Color.MAGENTA);
            g.drawRect((int)tmp.getPosition().x - 18, (int)tmp.getPosition().y - 18, 36, 36);
        }
        g.setColor(Color.WHITE);
        int[] nArray = draw = new int[]{50, 100, 150, 200, 250, 300, 350, 400, 450, 500};
        int n = draw.length;
        int n2 = 0;
        while (n2 < n) {
            d = nArray[n2];
            g.drawString(String.valueOf(d), d, 20);
            ++n2;
        }
        nArray = draw;
        n = draw.length;
        n2 = 0;
        while (n2 < n) {
            d = nArray[n2];
            g.drawString(String.valueOf(d), 20, d);
            ++n2;
        }
        g.setColor(c);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        Enemy en = EnemyManager.getInstance().get(event.getName());
        if (en != null) {
            en.setIfDead(true);
        }
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
    }

    @Override
    public void onStatus(StatusEvent e) {
    }

    @Override
    public void onWin(WinEvent event) {
    }
}

