/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import wcsv.Engineer.Gun.LogGun;
import wcsv.Engineer.Movement.WaveSurfingMovement;
import wcsv.Engineer.Radar.RadarCoordinator;
import wcsv.Engineer.Utilities.Target;
import wcsv.Engineer.Utilities.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Engineer
extends AdvancedRobot {
    private static LogGun gunner = null;
    private static WaveSurfingMovement mover = null;
    private static RadarCoordinator radar = null;
    private static int hits = 0;
    private static int misses = 0;
    private static int wins = 0;
    private Target target;
    private Target thisRobot;
    private ScannedRobotEvent lastScan;

    public void run() {
        Utilities.fWidth = this.getBattleFieldWidth();
        Utilities.fHeight = this.getBattleFieldHeight();
        this.setColors(Color.blue.darker(), Color.red.darker(), Color.red.darker());
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        if (this.getRoundNum() > 0) {
            System.out.print("Win %: ");
            System.out.println(Math.round((double)wins / (double)this.getRoundNum() * 100.0));
            gunner.reset();
            mover.reset();
        } else {
            gunner = new LogGun(this);
            mover = new WaveSurfingMovement(this);
            radar = new RadarCoordinator(this);
            System.out.println("Engineer 0.5.4 ready.");
        }
        this.lastScan = null;
        this.target = null;
        this.thisRobot = null;
        while (true) {
            if (this.lastScan != null) {
                this.handleScan(this.lastScan);
            }
            radar.performAction(this.target);
            if (this.target != null && this.getEnergy() > 0.0) {
                if (this.getOthers() > 0) {
                    gunner.operate(this.target, this.thisRobot);
                }
                mover.operate(this.target, this.thisRobot);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastScan = e;
    }

    public void handleScan(ScannedRobotEvent e) {
        if (this.target == null) {
            this.target = new Target(e, this);
        } else {
            this.target.update(e, this);
        }
        if (this.thisRobot == null) {
            this.thisRobot = new Target(this, e);
        } else {
            this.thisRobot.update(this, e);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        mover.onHitByBullet(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        this.target.tempDamage -= (double)3 * e.getBullet().getPower();
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        mover.onBulletHitBullet(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.getOthers() > 0) {
            ++LogGun.actualBulletHits;
        }
        this.target.tempDamage += e.getBullet().getPower() * (double)4;
        if (e.getBullet().getPower() > 1.0) {
            this.target.tempDamage += (e.getBullet().getPower() - 1.0) * (double)2;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        if (this.getOthers() > 0) {
            ++LogGun.actualBulletMisses;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("Skipped Turn");
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit Wall");
    }

    public void onWin(WinEvent e) {
        ++wins;
    }

    private final /* synthetic */ void this() {
        this.target = null;
        this.thisRobot = null;
        this.lastScan = null;
    }

    public Engineer() {
        this.this();
    }
}

