/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Utilities;

import java.awt.geom.Point2D;
import wcsv.Engineer.Utilities.Target;

public class Utilities {
    public static final double PI = Math.PI;
    public static final double TWOPI = Math.PI * 2;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double ROBOT_WIDTH = 40.0;
    public static final double MAX_TURNRATE = Math.toRadians(10.0);
    public static final double MAX_VEL = 8.0;
    public static final double MAX_ACCEL = 1.0;
    public static final double MAX_DECEL = 2.0;
    public static final Point2D.Double ORIGIN = new Point2D.Double(0.0, 0.0);
    public static double fWidth;
    public static double fHeight;

    public static double rollingAvg(double currentValue, double newSample, double samples, double maxDepth) {
        samples = Math.min(maxDepth, samples);
        return (currentValue * samples + newSample) / (samples + 1.0);
    }

    public static double rollingAvg(double currentValue, double newSample, double samples, double maxDepth, double weight) {
        samples = Math.min(maxDepth, samples);
        return (currentValue * samples + newSample * weight) / (samples + weight);
    }

    public static double rollingAvg(double currentValue, double newSample, double samples) {
        return (currentValue * samples + newSample) / (samples + 1.0);
    }

    public static int getSegment(double value, double[] segs) {
        int i = 0;
        while (i < segs.length) {
            if (value <= segs[i]) {
                return i;
            }
            ++i;
        }
        return segs.length - 1;
    }

    public static double wallCollisionAngle(Target t, Point2D.Double source, double direction, double maxAngle) {
        double delta = maxAngle / 15.0;
        double angle = 0.0;
        while (angle <= maxAngle) {
            if (Utilities.outsideWall(Utilities.projectPoint(source, angle * direction * (double)t.orbitDir + t.absoluteBearing, t.distance))) {
                return angle;
            }
            angle += delta;
        }
        return maxAngle;
    }

    public static double square(double n) {
        return n * n;
    }

    public static double maxTurnRate(double vel) {
        return 0.17453292519943295 - 0.01308996938995747 * Math.abs(vel);
    }

    public static double relativeAngle(double angle) {
        if (angle > -Math.PI && angle <= Math.PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -Math.PI) {
            fixedAngle += Math.PI * 2;
        }
        while (fixedAngle > Math.PI) {
            fixedAngle -= Math.PI * 2;
        }
        return fixedAngle;
    }

    public static double absoluteAngle(double angle) {
        if (angle >= 0.0 && angle < Math.PI * 2) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += Math.PI * 2;
        }
        while (fixedAngle >= Math.PI * 2) {
            fixedAngle -= Math.PI * 2;
        }
        return fixedAngle;
    }

    public static double relativeAngleToPoint(Point2D.Double p1, Point2D.Double p2) {
        return Math.atan2(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public static double absoluteAngleToPoint(Point2D.Double p1, Point2D.Double p2) {
        return Utilities.absoluteAngle(Utilities.relativeAngleToPoint(p1, p2));
    }

    public static double relativeAngleToPoint(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public static double absoluteAngleToPoint(double x1, double y1, double x2, double y2) {
        return Utilities.absoluteAngle(Utilities.relativeAngleToPoint(x1, y1, x2, y2));
    }

    public static double distance(Point2D.Double p1, Point2D.Double p2) {
        return Utilities.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Utilities.distanceSquared(x1, y1, x2, y2));
    }

    public static double distanceSquared(Point2D.Double p1, Point2D.Double p2) {
        return Utilities.distanceSquared(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double distanceSquared(double x1, double y1, double x2, double y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static Point2D.Double projectPoint(double x1, double y1, double bearing, double distance) {
        return new Point2D.Double(Utilities.projectX(x1, bearing, distance), Utilities.projectY(y1, bearing, distance));
    }

    public static Point2D.Double projectPoint(Point2D.Double source, double bearing, double distance) {
        return new Point2D.Double(Utilities.projectX(source.getX(), bearing, distance), Utilities.projectY(source.getY(), bearing, distance));
    }

    public static double projectX(double x1, double bearing, double distance) {
        return x1 + Math.sin(bearing) * distance;
    }

    public static double projectY(double y1, double bearing, double distance) {
        return y1 + Math.cos(bearing) * distance;
    }

    public static double maxEscapeAngle_Velocity(double vel) {
        return Math.asin(8.0 / vel);
    }

    public static double maxEscapeAngle_Power(double power) {
        return Utilities.maxEscapeAngle_Velocity(Utilities.bulletPowerToVelocity(power));
    }

    public static double bulletPowerToVelocity(double power) {
        return 20.0 - (double)3 * power;
    }

    public static int time(double distance, double velocity) {
        return (int)(distance / velocity);
    }

    public static double robotBearingRange(double distance) {
        return Utilities.halfRobotBearingRange(distance) * (double)2;
    }

    public static double halfRobotBearingRange(double distance) {
        return Math.atan(20.0 / distance);
    }

    public static boolean inRange(double min, double max, double val) {
        boolean bl = false;
        if (val >= min && val <= max) {
            bl = true;
        }
        return bl;
    }

    public static boolean outsideWall(Point2D.Double p) {
        boolean bl = false;
        if (p.getX() < 0.0 || p.getY() < 0.0 || p.getY() > fHeight || p.getX() > fWidth) {
            bl = true;
        }
        return bl;
    }

    public static int sign(double n) {
        if (n < 0.0) {
            return -1;
        }
        if (n > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double bulletDamage(double velocity) {
        double p = (20.0 - velocity) / (double)3;
        return (double)4 * p + (p > 1.0 ? (double)2 * (p - 1.0) : 0.0);
    }
}

