/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bandol.misc.Fncts;
import bandol.util.Queue;
import bandol.util.RandomPriorityChooser;
import bndl.Enemy;
import bndl.EnemyTable;
import bndl.Scan;
import bndl.VirtualBullet;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import robocode.AdvancedRobot;

public class CoolSpotNavigator {
    Point2D.Double spot;
    double coolValue;
    double movement;
    AdvancedRobot robot;
    Random rnd;
    Vector virtualBullets;
    Queue botStates;
    public static int MAX_DIRS = 8;
    public static double WALL = 30.0;

    public CoolSpotNavigator(AdvancedRobot advancedRobot) {
        this.robot = advancedRobot;
        this.botStates = new Queue(8);
        this.spot = null;
        this.rnd = new Random();
        this.virtualBullets = new Vector();
    }

    public void setup(EnemyTable enemyTable) {
        double d = 0.0;
        int n = 0;
        double d2 = WALL;
        while (d2 <= this.robot.getBattleFieldWidth() - WALL + 1.0) {
            double d3 = WALL;
            while (d3 <= this.robot.getBattleFieldHeight() - WALL + 1.0) {
                double d4 = this.getCoolValue(enemyTable, new Point2D.Double(d2, d3));
                ++n;
                if (d4 > d) {
                    d = d4;
                    this.spot = new Point2D.Double(d2, d3);
                }
                d3 += (this.robot.getBattleFieldHeight() - WALL * 2.0) / 3.0;
            }
            d2 += (this.robot.getBattleFieldWidth() - WALL * 2.0) / 3.0;
        }
        this.coolValue = d;
    }

    public double getNextDirection(EnemyTable enemyTable) {
        double d;
        double[] dArray = new double[MAX_DIRS];
        this.removeOldVirtualBullets();
        RandomPriorityChooser randomPriorityChooser = new RandomPriorityChooser();
        int n = 0;
        while (n < MAX_DIRS) {
            d = (double)n * Math.PI * 2.0 / (double)MAX_DIRS;
            dArray[n] = 55.0 * Math.abs(1.5707963267948966 - Math.abs(Fncts.normRelRadians(d - this.robot.getHeadingRadians())));
            if (Math.sin(d) < 0.0 && Math.abs((WALL - this.robot.getX()) / Math.sin(d)) < dArray[n]) {
                dArray[n] = Math.abs((WALL - this.robot.getX()) / Math.sin(d)) - 2.0;
            }
            if (Math.cos(d) < 0.0 && Math.abs((WALL - this.robot.getY()) / Math.cos(d)) < dArray[n]) {
                dArray[n] = Math.abs((WALL - this.robot.getY()) / Math.cos(d)) - 2.0;
            }
            if (Math.sin(d) > 0.0 && Math.abs((this.robot.getBattleFieldWidth() - WALL - this.robot.getX()) / Math.sin(d)) < dArray[n]) {
                dArray[n] = Math.abs((this.robot.getBattleFieldWidth() - WALL - this.robot.getX()) / Math.sin(d)) - 2.0;
            }
            if (Math.cos(d) > 0.0 && Math.abs((this.robot.getBattleFieldHeight() - WALL - this.robot.getY()) / Math.cos(d)) < dArray[n]) {
                dArray[n] = Math.abs((this.robot.getBattleFieldHeight() - WALL - this.robot.getY()) / Math.cos(d)) - 2.0;
            }
            if (dArray[n] < 3.0) {
                dArray[n] = 3.0;
            }
            Point2D.Double double_ = new Point2D.Double(this.robot.getX() + dArray[n] * Math.sin(d), this.robot.getY() + dArray[n] * Math.cos(d));
            double d2 = this.getPriority(enemyTable, double_);
            if (double_.x < WALL || double_.x > this.robot.getBattleFieldWidth() - WALL || double_.y < WALL || double_.y > this.robot.getBattleFieldHeight() - WALL) {
                d2 = 0.0;
            }
            randomPriorityChooser.add(new Integer(n), d2);
            ++n;
        }
        n = (Integer)randomPriorityChooser.get();
        double d3 = d = (double)n * Math.PI * 2.0 / (double)MAX_DIRS;
        this.movement = dArray[n];
        return d3;
    }

    public double getMovement() {
        return this.movement;
    }

    private double getCoolValue(EnemyTable enemyTable, Point2D.Double double_) {
        double d = Double.MAX_VALUE;
        Enumeration enumeration = enemyTable.keys();
        while (enumeration.hasMoreElements()) {
            Enemy enemy = (Enemy)enemyTable.get(enumeration.nextElement());
            double d2 = double_.distance(enemy.getX(), enemy.getY());
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    private double getPriority(EnemyTable enemyTable, Point2D.Double double_) {
        double d;
        double d2 = Fncts.calcHeadingRadians(this.robot.getX(), this.robot.getY(), double_.x, double_.y);
        double d3 = Double.MAX_VALUE;
        Enumeration enumeration = enemyTable.keys();
        while (enumeration.hasMoreElements()) {
            Enemy enemy = (Enemy)enemyTable.get(enumeration.nextElement());
            d = enemy.getEstimatedPosition(4L).distance(double_);
            if (!(d < d3)) continue;
            d3 = d;
        }
        d = 1.0 / (1.0 + Math.exp(-2.0 * (d3 - 80.0)));
        if (Math.abs(Fncts.normRelRadians(this.robot.getHeadingRadians() - d2)) > 1.5707963267948966) {
            d /= 4.0;
        }
        if (this.spot != null) {
            double d4 = this.spot.distance(this.robot.getX(), this.robot.getY()) + 10.0;
            if (this.spot.distance(this.robot.getX(), this.robot.getY()) > this.coolValue / 3.0) {
                d = d * 1.0 / (1.0 + Math.exp(-1.0 * (d4 - this.spot.distance(double_))));
            }
        }
        Enumeration enumeration2 = this.virtualBullets.elements();
        while (enumeration2.hasMoreElements()) {
            double d5;
            VirtualBullet virtualBullet = (VirtualBullet)enumeration2.nextElement();
            double d6 = this.robot.getX();
            double d7 = virtualBullet.getPosition((long)this.robot.getTime()).x;
            double d8 = virtualBullet.getStartPosition().x;
            double d9 = virtualBullet.getStartPosition().y;
            double d10 = this.robot.getY();
            double d11 = Math.abs((d7 - d8) * (d9 - d10) - (d8 - d6) * ((d5 = virtualBullet.getPosition((long)this.robot.getTime()).y) - d9)) / Math.sqrt((d7 - d8) * (d7 - d8) + (d5 - d9) * (d5 - d9));
            if (!(d11 < 20.0)) continue;
            d *= 0.1;
            d = d * virtualBullet.getPosition(this.robot.getTime()).distance(d6, d10) / virtualBullet.getStartPosition().distance(d6, d10);
        }
        return d;
    }

    public void addVirtualBullet(Enemy enemy, double d) {
        if (this.robot.getOthers() <= 2 || enemy.getDistance(this.robot.getX(), this.robot.getY()) < 300.0) {
            double d2 = this.intercept(enemy, d, 0.0, 60.0);
            VirtualBullet virtualBullet = new VirtualBullet(enemy.getPosition(), this.robot.getTime(), d2, d);
            this.virtualBullets.add(virtualBullet);
        }
    }

    private void removeOldVirtualBullets() {
        Enumeration enumeration = this.virtualBullets.elements();
        while (enumeration.hasMoreElements()) {
            VirtualBullet virtualBullet = (VirtualBullet)enumeration.nextElement();
            if (!(virtualBullet.getStartPosition().distance(virtualBullet.getPosition(this.robot.getTime())) > virtualBullet.getStartPosition().distance(this.robot.getX(), this.robot.getY()))) continue;
            this.virtualBullets.remove(virtualBullet);
        }
    }

    public void addBotState() {
        this.botStates.add(new Scan(this.robot.getHeadingRadians(), this.robot.getVelocity(), this.robot.getEnergy(), this.robot.getTime(), this.robot.getX(), this.robot.getY()));
    }

    public double f(double d, double d2, Enemy enemy) {
        double d3 = 20.0 - 3.0 * d2;
        double d4 = this.getEstimatedPosition((long)d, this.botStates).distance(enemy.getPosition());
        return d4 - d3 * d;
    }

    public double intercept(Enemy enemy, double d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = this.f(d5, d, enemy);
        int n = 0;
        while (Math.abs(d4 - d5) >= 0.1 && n < 15) {
            ++n;
            double d7 = this.f(d4, d, enemy);
            if (d7 - d6 == 0.0) break;
            double d8 = d4 - d7 * (d4 - d5) / (d7 - d6);
            d5 = d4;
            d4 = d8;
            d6 = d7;
        }
        Point2D.Double double_ = this.getEstimatedPosition((long)d4, this.botStates);
        return Fncts.normRelRadians(Fncts.calcHeadingRadians(enemy.getPosition(), double_));
    }

    public Point2D.Double getEstimatedPosition(long l, Queue queue) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (queue.size() == 0) {
            return double_;
        }
        if (queue.size() >= 1) {
            Scan scan = (Scan)queue.get(0);
            if (queue.size() == 1) {
                double_.x = scan.getX() + scan.getVelocity() * (double)l * Math.sin(scan.getHeading());
                double_.y = scan.getY() + scan.getVelocity() * (double)l * Math.cos(scan.getHeading());
            } else if (queue.size() >= 2) {
                Scan scan2 = (Scan)queue.get(1);
                if (queue.size() == 2 || scan.getHeading() - scan2.getHeading() < 0.1) {
                    double_.x = scan.getX() + scan.getVelocity() * (double)l * Math.sin(scan.getHeading());
                    double_.y = scan.getY() + scan.getVelocity() * (double)l * Math.cos(scan.getHeading());
                } else if (queue.size() >= 3) {
                    Scan scan3 = (Scan)queue.get(2);
                    Ellipse2D.Double double_2 = Fncts.getCircle(scan.getPosition(), scan2.getPosition(), scan3.getPosition());
                    if (double_2 != null && double_2.getWidth() != 0.0) {
                        double d = double_2.getWidth() / 2.0;
                        Point2D.Double double_3 = new Point2D.Double(double_2.getX() + d, double_2.getY() + d);
                        double d2 = scan.getVelocity() * (double)l / (Math.PI * 2 * d);
                        double d3 = Fncts.calcHeadingRadians(scan.getPosition(), double_3);
                        double_.x = double_3.x + d * Math.sin(d3 + d2);
                        double_.y = double_3.y + d * Math.cos(d3 + d2);
                    } else {
                        double_.x = scan.getX() + scan.getVelocity() * (double)l * Math.sin(scan.getHeading());
                        double_.y = scan.getY() + scan.getVelocity() * (double)l * Math.cos(scan.getHeading());
                    }
                }
            }
        }
        if (double_.x < 18.0) {
            double_.x = 18.0;
        }
        if (double_.x > this.robot.getBattleFieldWidth() - 18.0) {
            double_.x = this.robot.getBattleFieldWidth() - 18.0;
        }
        if (double_.y < 18.0) {
            double_.y = 18.0;
        }
        if (double_.y > this.robot.getBattleFieldHeight() - 18.0) {
            double_.y = this.robot.getBattleFieldHeight() - 18.0;
        }
        return double_;
    }
}

