/*
 * Decompiled with CFR 0.152.
 */
package apv;

import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Aspid
extends AdvancedRobot {
    static final double epsilon = 0.05;
    static final int embed = 1;
    static final int delay = 1;
    static double lastHeading;
    static int time;
    static int n;
    static double[] ev;
    static double[] eh;
    static int[] i1;
    static int i1d;
    static double power;
    static double eGetDistance;
    static double targetBearing;
    static String botclass;

    public void run() {
        double bestY;
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        double bestA = Math.PI;
        double nextMove = Math.PI;
        double bestX = bestY = (double)2;
        double lastMove = bestY;
        power = bestY;
        while (true) {
            double d;
            double x = this.getX();
            double y = this.getY();
            lastMove += 1.0;
            if (d >= nextMove) {
                nextMove = 1.0;
                bestA = this.normalRelativeAngle(Math.atan2(bestX - x, bestY - y) - this.getHeadingRadians());
                lastMove = Math.atan(Math.tan(bestA));
                if (lastMove != bestA) {
                    nextMove = -1.0;
                    bestA = lastMove;
                }
                this.setTurnRightRadians(bestA);
                this.setAhead(nextMove * Point2D.distance(bestX, bestY, x, y));
                bestA = Double.POSITIVE_INFINITY;
                nextMove = Double.POSITIVE_INFINITY;
                lastMove = 0.0;
            } else {
                double d2;
                double nextX = this.newpos(this.getBattleFieldWidth());
                double nextY = this.newpos(this.getBattleFieldHeight());
                y = Math.atan2(nextX - x, nextY - y);
                x = (double)2 * this.scoring(targetBearing - y) + this.scoring(this.getHeadingRadians() - y);
                if (d2 < bestA) {
                    bestX = nextX;
                    bestY = nextY;
                    bestA = x;
                }
            }
            nextMove = Math.min(nextMove, eGetDistance / 17.0);
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        botclass = this.getBotClass(e.getName());
        if (ev == null) {
            ev = new double[25000];
            eh = new double[25000];
            double[][] d = (double[][])Aspid.readCompressedObject(botclass, this);
            if (d != null) {
                System.arraycopy(d[0], 0, ev, 0, 3000);
                System.arraycopy(d[1], 0, eh, 0, 3000);
                n = 2999;
            }
        }
        targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(this.normalRelativeAngle(targetBearing - this.getRadarHeadingRadians()) * 1.9);
        Aspid.eh[Aspid.n] = this.normalRelativeAngle(e.getHeadingRadians() - lastHeading);
        lastHeading = e.getHeadingRadians();
        Aspid.ev[Aspid.n] = e.getVelocity();
        eGetDistance = e.getDistance();
        time = (int)(eGetDistance / (20.0 - (double)3 * power));
        this.setTurnGunRightRadians(this.normalRelativeAngle(this.iterativepatternfit() - this.getGunHeadingRadians()));
        if (this.getEnergy() > power + 0.1) {
            this.setFire(power);
            power = 3;
        }
        if (this.getEnergy() <= (double)3) {
            power = 0.2;
        }
        ++n;
        n %= 24900;
    }

    public double iterativepatternfit() {
        i1d = 0;
        int i = (int)((double)n - eGetDistance / (double)5);
        while (i >= Math.max(1, n - 5000)) {
            Aspid.i1[Aspid.i1d++] = i--;
        }
        int match = 0;
        int accdel = 0;
        int previ1d = 0;
        while (i1d > 0) {
            previ1d = i1d;
            match = this.fitpattern(1, 1, accdel);
            ++accdel;
        }
        double mex = this.getX();
        double mey = this.getY();
        if (previ1d == 0) {
            return targetBearing;
        }
        if (accdel - 1 == 0) {
            return this.predictbearing(match, power);
        }
        ArrayList<Double> be = new ArrayList<Double>();
        int i2 = 0;
        while (i2 < previ1d) {
            be.add(new Double(this.predictbearing(i1[i2], power)));
            ++i2;
        }
        Collections.sort(be);
        double maxval = 0.0;
        int maxcount = 0;
        int i3 = 0;
        while (i3 < be.size()) {
            int count = 0;
            Double curval = (Double)be.get(i3);
            while (i3 < be.size() && (Double)be.get(i3) <= curval + 0.09) {
                ++count;
                ++i3;
            }
            if (count <= maxcount) continue;
            maxcount = count;
            maxval = curval;
        }
        return maxval + 0.045;
    }

    public int fitpattern(int m, int d, int accd) {
        int nid = 0;
        int match = -1;
        double low = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < i1d) {
            double score = 0.0;
            int j = m - 1;
            while (j >= 0 && score <= low) {
                int ii = i1[i] - accd - j * d;
                int in = n - accd - j * d;
                score = ii >= 0 ? (score += Math.pow(ev[in] - ev[ii], 2) / 8.0 + Math.pow(eh[in] - eh[ii], 2) / 0.17) : (score += low);
                --j;
            }
            if (score < 0.05) {
                Aspid.i1[nid++] = i1[i];
            }
            if (score <= low) {
                match = i1[i];
                low = score;
            }
            ++i;
        }
        i1d = nid;
        return match;
    }

    public double predictbearing(int match, double power) {
        double x = Math.sin(targetBearing) * eGetDistance;
        double y = Math.cos(targetBearing) * eGetDistance;
        double ah = lastHeading + (ev[n] * ev[match] < 0.0 ? Math.PI : 0.0);
        int time = 2;
        while ((double)time * (20.0 - (double)3 * power) < Point2D.distance(0.0, 0.0, x, y)) {
            x += Math.sin(ah) * ev[match + 1 + time];
            y += Math.cos(ah) * ev[match + 1 + time];
            ah += eh[match + 1 + time];
            ++time;
        }
        return Math.atan2(x, y);
    }

    private final double normalRelativeAngle(double angle) {
        return (angle + Math.PI * 5) % (Math.PI * 2) - Math.PI;
    }

    private final double scoring(double a1) {
        return Math.abs(Math.abs(this.normalRelativeAngle(a1)) - 1.5707963267948966);
    }

    private final double newpos(double len) {
        return 100.0 + Math.random() * (len - 200.0);
    }

    private final String getBotClass(String name) {
        String n = name;
        int low = name.indexOf(" ");
        if (low >= 0) {
            n = name.substring(0, low);
        }
        return n;
    }

    public void onDeath(DeathEvent e) {
        this.onWin(null);
    }

    public void onWin(WinEvent e) {
        if (this.getRoundNum() == this.getNumRounds() - 1 && n > 3000) {
            double[][] d = new double[2][3000];
            System.arraycopy(ev, n - 3001, d[0], 0, 3000);
            System.arraycopy(eh, n - 3001, d[1], 0, 3000);
            Aspid.writeObject(d, botclass, this);
        }
    }

    public static Object readCompressedObject(String filename, AdvancedRobot bot) {
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(bot.getDataFile(filename + ".zip")));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void writeObject(Object obj, String filename, AdvancedRobot bot) {
        try {
            ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(bot.getDataFile(filename + ".zip")));
            zipout.setLevel(9);
            zipout.putNextEntry(new ZipEntry(filename));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(obj);
            out.flush();
            zipout.closeEntry();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        ev = null;
        eh = null;
        i1 = new int[25000];
    }
}

