/*
 * Decompiled with CFR 0.152.
 */
package bh;

import bh.components.graphics.BotPainter;
import bh.components.history.History;
import bh.components.history.HistoryEventListener;
import bh.components.history.RobotState;
import bh.components.history.analysis.BotTracker;
import bh.components.history.analysis.HistoricalEventParser;
import bh.components.history.analysis.HistoricalInferenceMaker;
import bh.facade.FacadeBot;
import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Duration;
import bh.units.Energy;
import bh.units.Heading;
import bh.units.Location;
import bh.units.RelativeLocation;
import bh.units.Units;
import bh.util.Vector;
import java.awt.Color;
import java.util.ArrayList;

public class PencilRain
extends FacadeBot {
    public void run() {
        this.init();
        History history = new History();
        new HistoryEventListener(this, history);
        HistoricalEventParser historyParser = new HistoricalEventParser(this.getName(), history);
        HistoricalInferenceMaker historyInferer = new HistoricalInferenceMaker(history);
        BotTracker botTracker = new BotTracker(history);
        BotTracker.SingleCondition locTracker = new BotTracker.SingleCondition(botTracker, BotTracker.allLocInfo);
        BotPainter botPainter = new BotPainter(this, locTracker);
        this.setAllColors(Color.RED);
        Location cntr = new Location(this.battleFieldWidth().divide(2.0), this.battleFieldHeight().divide(2.0));
        Heading hdngToCntr = cntr.toVector().minus(this.location().toVector()).toHeading();
        Bearing initUnitCntrBrng = new Bearing(Angle.fromDegrees(Units.signum(this.heading().getBearingTo(hdngToCntr))));
        String enemyName = null;
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            historyParser.parseAndStore();
            historyInferer.inferAndStore();
            if (locTracker.getKnownBots().size() < 2) {
                this.setTurnRight(initUnitCntrBrng.times(10.0));
                this.setTurnGunRight(initUnitCntrBrng.times(20.0));
                this.setTurnRadarRight(initUnitCntrBrng.times(45.0));
            } else {
                if (enemyName == null) {
                    ArrayList<String> botNames = new ArrayList<String>(locTracker.getKnownBots());
                    enemyName = ((String)botNames.get(0)).equals(this.getName()) ? (String)botNames.get(1) : (String)botNames.get(0);
                }
                RobotState rs = locTracker.getLatest(enemyName).state();
                Location enemyLocGuess = rs.location().plus(new RelativeLocation(rs.heading(), rs.speed().times(Duration.A_TURN)));
                Vector toEnemy = new Vector(this.location().toVector(), enemyLocGuess.toVector());
                Heading hdngToEnemy = toEnemy.toHeading();
                double radarTurn = this.radarHeading().getBearingTo(hdngToEnemy).toDouble();
                if (radarTurn == 0.0) {
                    radarTurn = 0.01;
                }
                this.setTurnRadarRight(radarTurn);
                double gunTurn = this.gunHeading().getBearingTo(hdngToEnemy).toDouble();
                this.setTurnGunRight(gunTurn);
                this.setFire(new Energy(0.1));
                this.setTurnRight(new Bearing(Angle.fromDegrees(2.0)));
                this.setAhead(new Distance(7.0));
            }
            botPainter.paint();
            this.execute();
        }
    }
}

