/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.units.Angle;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heading;
import bh.units.Location;
import bh.units.Time;
import robocode.Bullet;

public final class BulletRecord {
    private final Bullet bullet;
    private final Energy power;
    private final Time firedAt;
    private final Location source;
    private final Heading heading;
    private final String shooter;
    private final String victim;
    private final Boolean isActive;

    BulletRecord(Bullet bullet, Energy power, Time firedAt, Location source, Heading heading, String shooter, String victim, Boolean isActive) {
        this.bullet = bullet;
        this.power = power;
        this.firedAt = firedAt;
        this.source = source;
        this.heading = heading;
        this.shooter = shooter;
        this.victim = victim;
        this.isActive = isActive;
    }

    public BulletRecord(Bullet bullet) {
        this.bullet = bullet;
        this.power = new Energy(bullet.getPower());
        this.firedAt = null;
        this.source = new Location(new Distance(bullet.getX()), new Distance(bullet.getY()));
        this.heading = new Heading(Angle.fromDegrees(bullet.getHeading()));
        this.shooter = bullet.getName();
        this.victim = bullet.getVictim();
        this.isActive = bullet.isActive();
    }

    public Bullet bullet() {
        return this.bullet;
    }

    public Energy power() {
        return this.power;
    }

    public Time firedAt() {
        return this.firedAt;
    }

    public Location source() {
        return this.source;
    }

    public Heading heading() {
        return this.heading;
    }

    public String shooter() {
        return this.shooter;
    }

    public String victim() {
        return this.victim;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public static class Builder {
        public Bullet bullet = null;
        public Energy power = null;
        public Time firedAt = null;
        public Location source = null;
        public Heading heading = null;
        public String shooter = null;
        public String victim = null;
        public Boolean isActive = null;

        public Builder bullet(Bullet bullet) {
            this.bullet = bullet;
            return this;
        }

        public Builder power(Energy power) {
            this.power = power;
            return this;
        }

        public Builder power(double power) {
            return this.power(new Energy(power));
        }

        public Builder firedAt(Time firedAt) {
            this.firedAt = firedAt;
            return this;
        }

        public Builder firedAt(int firedAt) {
            return this.firedAt(new Time(firedAt));
        }

        public Builder source(Location source) {
            this.source = source;
            return this;
        }

        public Builder source(double x, double y) {
            return this.source(new Location(new Distance(x), new Distance(y)));
        }

        public Builder heading(Heading heading) {
            this.heading = heading;
            return this;
        }

        public Builder heading(double heading) {
            return this.heading(new Heading(Angle.fromDegrees(heading)));
        }

        public Builder shooter(String shooter) {
            this.shooter = shooter;
            return this;
        }

        public Builder victim(String victim) {
            this.victim = victim;
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public BulletRecord build() {
            return new BulletRecord(this.bullet, this.power, this.firedAt, this.source, this.heading, this.shooter, this.victim, this.isActive);
        }
    }
}

