/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history.analysis;

import bh.components.history.History;
import bh.components.history.RobotRecord;
import bh.components.history.RobotState;
import bh.components.history.analysis.interfaces.BotCondition;
import bh.components.history.analysis.interfaces.BotListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BotTracker
implements BotListener {
    public static final BotCondition allLocInfo = new BotCondition(){

        public boolean isMet(RobotRecord robotRecord) {
            RobotState rs = robotRecord.state();
            return rs != null && rs.location() != null && rs.heading() != null && rs.speed() != null;
        }
    };
    private final Map<BotCondition, Integer> numRecords = new HashMap<BotCondition, Integer>();
    private final Map<BotCondition, Map<String, Deque<RobotRecord>>> latestKnown = new HashMap<BotCondition, Map<String, Deque<RobotRecord>>>();

    public BotTracker(History history) {
        history.registerListener(this);
    }

    public void addCondition(BotCondition botCondition, int numRecords) {
        this.numRecords.put(botCondition, numRecords);
        this.latestKnown.put(botCondition, new HashMap());
    }

    public void addCondition(BotCondition botCondition) {
        this.addCondition(botCondition, 1);
    }

    @Override
    public void record(RobotRecord robotRecord) {
        for (Map.Entry<BotCondition, Map<String, Deque<RobotRecord>>> e : this.latestKnown.entrySet()) {
            BotCondition condition = e.getKey();
            if (!condition.isMet(robotRecord)) continue;
            Integer size = this.numRecords.get(condition);
            Map<String, Deque<RobotRecord>> recordsForAllBots = e.getValue();
            Deque<RobotRecord> records = recordsForAllBots.get(robotRecord.name());
            if (records == null) {
                records = new ArrayDeque<RobotRecord>(size);
                recordsForAllBots.put(robotRecord.name(), records);
            }
            records.offer(robotRecord);
            while (records.size() > size) {
                records.poll();
            }
        }
    }

    public Set<String> getKnownBots(BotCondition botCondition) {
        if (!this.latestKnown.containsKey(botCondition)) {
            return null;
        }
        return this.latestKnown.get(botCondition).keySet();
    }

    public Deque<RobotRecord> getRecords(BotCondition botCondition, String botName) {
        if (!this.latestKnown.containsKey(botCondition)) {
            return null;
        }
        return this.latestKnown.get(botCondition).get(botName);
    }

    public RobotRecord getLatest(BotCondition botCondition, String botName) {
        return this.getRecords(botCondition, botName).peekLast();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleCondition {
        private final BotTracker botTracker;
        private final BotCondition botCondition;

        public SingleCondition(BotTracker botTracker, BotCondition botCondition, int numRecords) {
            this.botTracker = botTracker;
            this.botCondition = botCondition;
            this.botTracker.addCondition(this.botCondition, numRecords);
        }

        public SingleCondition(BotTracker botTracker, BotCondition botCondition) {
            this(botTracker, botCondition, 1);
        }

        public Set<String> getKnownBots() {
            return this.botTracker.getKnownBots(this.botCondition);
        }

        public Deque<RobotRecord> getRecords(String botName) {
            return this.botTracker.getRecords(this.botCondition, botName);
        }

        public RobotRecord getLatest(String botName) {
            return this.botTracker.getLatest(this.botCondition, botName);
        }
    }
}

