/*
 * Decompiled with CFR 0.152.
 */
package bh.util;

import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Heading;

public class Vector {
    private final Distance x;
    private final Distance y;

    public Vector(Vector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector(Distance x, Distance y) {
        this.x = x;
        this.y = y;
    }

    public Vector(Vector source, Vector target) {
        this(target.minus(source));
    }

    public Vector(Heading heading) {
        this(new Distance(heading.toAngle().sin()), new Distance(heading.toAngle().cos()));
    }

    public Distance getX() {
        return this.x;
    }

    public Distance getY() {
        return this.y;
    }

    public Vector negate() {
        return new Vector(this.getX().negate(), this.getY().negate());
    }

    public Vector plus(Vector v) {
        return new Vector(this.getX().plus(v.getX()), this.getY().plus(v.getY()));
    }

    public Vector minus(Vector v) {
        return this.plus(v.negate());
    }

    public Vector times(double scalar) {
        return new Vector(this.getX().times(scalar), this.getY().times(scalar));
    }

    public Vector divide(double scalar) {
        assert (scalar != 0.0);
        assert (!Double.isNaN(scalar));
        return this.times(1.0 / scalar);
    }

    public Vector withMagnitude(double scalar) {
        return this.unitize().times(scalar);
    }

    public Distance getMagnitude() {
        return new Distance(Math.sqrt(this.getX().toDouble() * this.getX().toDouble() + this.getY().toDouble() * this.getY().toDouble()));
    }

    public Vector unitize() {
        return this.divide(this.getMagnitude().toDouble());
    }

    public double dot(Vector v) {
        return this.x.toDouble() * v.x.toDouble() + this.y.toDouble() * v.y.toDouble();
    }

    public Vector projectionOn(Vector v) {
        return v.unitize().times(this.dot(v) / v.getMagnitude().toDouble());
    }

    public Heading toHeading() {
        return new Heading(Angle.atan2(this.getX(), this.getY()));
    }

    public Bearing getBearingTo(Vector v) {
        return this.toHeading().getBearingTo(v.toHeading());
    }

    public Bearing getBearingFrom(Vector v) {
        return this.toHeading().getBearingFrom(v.toHeading());
    }

    public String toString() {
        return "<" + this.getX() + ", " + this.getY() + ">";
    }

    public String toStringPolar() {
        return "<" + this.toHeading() + ", " + this.getMagnitude() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)o;
        return v.x.equals(this.x) && v.y.equals(this.y);
    }

    public int hashCode() {
        return this.x.hashCode() * 31 + this.y.hashCode();
    }
}

