/*
 * Decompiled with CFR 0.152.
 */
package com.cgarias.rc;

import com.cgarias.rc.AdvancedEnemyBot;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class AdvancedBaseRobot
extends AdvancedRobot {
    PrintStream ps;
    NumberFormat f;
    static final double INITIAL_GUN_TURN_AMT = 10.0;
    static final double FAR_AWAY = 150.0;
    static final double TOO_CLOSE = 100.0;
    int count = 0;
    double gunTurnAmt;
    String trackName;
    AdvancedEnemyBot enemy = new AdvancedEnemyBot();
    private boolean justScanning = false;
    protected Map<String, AdvancedEnemyBot> robotsMap = new TreeMap<String, AdvancedEnemyBot>();
    protected TreeSet<AdvancedEnemyBot> robotsSet = new TreeSet();

    public void runAdvancedTracker() {
        this.setTurnGunRight(this.gunTurnAmt);
        ++this.count;
        if (this.count > 2) {
            this.gunTurnAmt = -10.0;
        }
        if (this.count > 5) {
            this.gunTurnAmt = 10.0;
        }
        if (this.count > 11) {
            this.trackName = null;
        }
        this.execute();
    }

    public void runAdvancedTrackerPredictiveShooter() {
        this.setTurnRadarRight(360.0);
        this.doChoosePredictiveShoot();
        this.execute();
    }

    public void prepareAdvancedTracker() {
        this.trackName = null;
        this.setAdjustGunForRobotTurn(true);
        this.gunTurnAmt = 10.0;
    }

    public void prepareAdvancedTrackerPredictiveShooter() {
        this.setBodyColor(new Color(0, 0, 0));
        this.setGunColor(new Color(0, 150, 50));
        this.setRadarColor(new Color(0, 100, 100));
        this.setBulletColor(new Color(255, 255, 100));
        this.setScanColor(new Color(255, 200, 200));
        this.trackName = null;
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.gunTurnAmt = 10.0;
        this.setTurnRadarRight(360.0);
    }

    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public void updateRobotInfoWithList(ScannedRobotEvent e) {
        AdvancedEnemyBot robotInfo = this.robotsMap.get(e.getName());
        if (robotInfo == null) {
            robotInfo = new AdvancedEnemyBot(e, (Robot)this);
            this.robotsMap.put(e.getName(), robotInfo);
            this.robotsSet.add(robotInfo);
        } else {
            this.robotsSet.remove(robotInfo);
            robotInfo.update(e, (Robot)this);
            this.robotsSet.add(robotInfo);
        }
        if (this.trackName == null || !this.trackName.equals(this.robotsSet.first().getName())) {
            this.enemy = this.robotsSet.first();
            this.trackName = this.enemy.getName();
            System.out.println("Traking" + this.trackName);
        }
    }

    public void updateRobotInfo(ScannedRobotEvent e) {
        AdvancedEnemyBot aeb = new AdvancedEnemyBot(e, (Robot)this);
        if (this.enemy.none() || aeb.getPriority() < this.enemy.getPriority() || aeb.getName().equals(this.enemy.getName())) {
            this.enemy = aeb;
            this.trackName = this.enemy.getName();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        AdvancedEnemyBot robotInfo = this.robotsMap.remove(e.getName());
        if (robotInfo == null) {
            System.out.println("Null:" + e.getName());
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println(this.robotsSet);
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println("**********************************");
            return;
        }
        this.robotsSet.remove(robotInfo);
    }

    public void onRobotDeathAdvancedTrackerPredictiveShooter(RobotDeathEvent e) {
        if (e.getName().equals(this.enemy.getName())) {
            this.enemy.reset();
        }
    }

    public void onScannedRobotAdvancedTrackerPredictiveShooter(ScannedRobotEvent e) {
        this.updateRobotInfo(e);
    }

    public void onScannedRobotAdvancedTracker(ScannedRobotEvent e) {
        this.updateRobotInfo(e);
        if (this.trackName != null && !e.getName().equals(this.trackName)) {
            return;
        }
        if (this.trackName == null) {
            this.trackName = e.getName();
            this.out.println("Tracking " + this.trackName);
        }
        this.count = 0;
        if (e.getDistance() > 150.0) {
            this.gunTurnAmt = this.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
            this.setTurnGunRight(this.gunTurnAmt);
            this.setTurnRight(e.getBearing());
            this.setAhead(e.getDistance() - 100.0);
            return;
        }
        this.gunTurnAmt = this.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
        this.setTurnGunRight(this.gunTurnAmt);
        this.setFire(3.0);
        if (e.getDistance() < 100.0) {
            if (e.getBearing() > -90.0 && e.getBearing() <= 90.0) {
                this.setBack(40.0);
            } else {
                this.setAhead(40.0);
            }
        }
        this.scan();
    }

    void doPredictiveShoot() {
        if (this.enemy == null) {
            System.out.println("Null enemy???");
            return;
        }
        double firePower = Math.min(500.0 / this.enemy.getDistance(), 3.0);
        double bulletSpeed = 20.0 - firePower * 3.0;
        long time = (long)(this.enemy.getDistance() / bulletSpeed);
        double futureX = this.enemy.getFutureX(time);
        double futureY = this.enemy.getFutureY(time);
        double absDeg = this.absoluteBearing(this.getX(), this.getY(), futureX, futureY);
        this.gunTurnAmt = this.normalizeBearing(absDeg - this.getGunHeading());
        this.setTurnGunRight(this.gunTurnAmt);
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 10.0) {
            this.setFire(firePower);
        }
    }

    public void doChoosePredictiveShoot() {
        if (this.enemy.none()) {
            return;
        }
        if (this.enemy.getDistance() > 150.0) {
            this.aproach(this.enemy);
            return;
        }
        this.doPredictiveShoot();
        if (this.enemy.getDistance() < 100.0) {
            this.retire(this.enemy);
        }
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    void aproach(AdvancedEnemyBot e) {
        this.gunTurnAmt = this.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
        this.setTurnGunRight(this.gunTurnAmt);
        this.setTurnRight(e.getBearing());
        this.setAhead(e.getDistance() - 140.0);
    }

    void retire(AdvancedEnemyBot e) {
        if (e.getBearing() > -90.0 && e.getBearing() <= 90.0) {
            this.setBack(40.0);
        } else {
            this.setAhead(40.0);
        }
    }
}

