/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile.driver;

import cbot.agile.CU;
import cbot.agile.Nibbler;
import cbot.agile.Point;
import cbot.agile.Pray;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractDriver {
    protected Nibbler robot;
    protected Pray currentPray;
    protected int drivingDirection;

    public void update(Nibbler robot) {
        this.robot = robot;
    }

    public void drive(Pray pray) {
        this.currentPray = pray;
    }

    public void victoryDance() {
        this.robot.setStop();
    }

    public void handleBeeingHit() {
    }

    public void handleHitWall(double angle) {
    }

    public void handleBeingFiredAt(Pray pray, double firePower, double fireTime) {
    }

    protected void steerRight(double angle) {
        if (angle > 90.0) {
            angle -= 180.0;
            this.drivingDirection = -1;
        } else if (angle < -90.0) {
            angle += 180.0;
            this.drivingDirection = -1;
        } else {
            this.drivingDirection = 1;
        }
        this.robot.setTurnRight(angle);
    }

    protected void forward(double distance) {
        this.robot.setAhead((double)this.drivingDirection * distance);
    }

    protected double getRealHeading() {
        double realHeading = this.robot.getHeading();
        if (this.drivingDirection == -1) {
            realHeading = CU.normalRelativeAngle(realHeading + 180.0);
        }
        if (realHeading < 0.0) {
            realHeading = 360.0 + realHeading;
        }
        return realHeading;
    }

    protected double getParallelAngle() {
        if (this.currentPray == null) {
            return 0.0;
        }
        return CU.normalRelativeAngle(this.robot.getHeading() + this.currentPray.getBearing() + 90.0);
    }

    protected double getGoToAngle(Point nextStop) {
        return Math.toDegrees(this.robot.getCordinate().getAngle(nextStop)) - this.robot.getHeading();
    }

    private final /* synthetic */ void this() {
        this.drivingDirection = 1;
    }

    public AbstractDriver(Nibbler robot) {
        this.this();
        this.robot = robot;
    }
}

