/*
 * Decompiled with CFR 0.152.
 */
package yarhoslav;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;
import yarhoslav.Enemigo;
import yarhoslav.Entidad;
import yarhoslav.Piloto;
import yarhoslav.Radar;

public class YaroBot
extends AdvancedRobot {
    private final Map mContexto = new ConcurrentHashMap();
    private Radar mRadar;
    private Enemigo mEnemigo;
    private Piloto mPiloto;
    private Map<String, Entidad> mEntidades;
    private final boolean mDebugPaint = false;

    public void run() {
        this.mRadar = new Radar(this.mContexto);
        this.mEnemigo = new Enemigo(this.mContexto);
        this.mEntidades = new ConcurrentHashMap<String, Entidad>();
        this.mPiloto = new Piloto(this.mContexto);
        this.mContexto.put("PARENT", this);
        this.mContexto.put("RADAR", this.mRadar);
        this.mContexto.put("ENEMIGO", this.mEnemigo);
        this.mContexto.put("ENTIDADES", this.mEntidades);
        this.mContexto.put("PILOTO", this.mPiloto);
        this.out.println("ONRUN: Iniciando...");
        this.setColors(Color.blue, Color.blue, Color.green);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.out.println("RUN");
            this.mRadar.ejecutar();
            for (Entidad value : this.mEntidades.values()) {
                value.ejecutar();
            }
            this.mPiloto.ejecutar();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.mRadar.onScannedRobot(e);
        this.out.println("ONSCANNEDROBOT: Radar:" + this.getRadarHeading());
        double FIREPOWER = 2.0;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = this.getHeadingRadians() + e.getBearingRadians();
        double rX = this.getX();
        double rY = this.getY();
        double bV = Rules.getBulletSpeed((double)2.0);
        double eX = rX + e.getDistance() * Math.sin(eAbsBearing);
        double eY = rY + e.getDistance() * Math.cos(eAbsBearing);
        double eV = e.getVelocity();
        double eHd = e.getHeadingRadians();
        double A = (eX - rX) / bV;
        double B = eV / bV * Math.sin(eHd);
        double C = (eY - rY) / bV;
        double D = eV / bV * Math.cos(eHd);
        double a = A * A + C * C;
        double b = 2.0 * (A * B + C * D);
        double c = B * B + D * D - 1.0;
        double discrim = b * b - 4.0 * a * c;
        if (discrim >= 0.0) {
            double t2;
            double t1 = 2.0 * a / (-b - Math.sqrt(discrim));
            double t = Math.min(t1, t2 = 2.0 * a / (-b + Math.sqrt(discrim))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = this.limit(eX + eV * t * Math.sin(eHd), 8.0, this.getBattleFieldWidth() - 8.0);
            double endY = this.limit(eY + eV * t * Math.cos(eHd), 8.0, this.getBattleFieldHeight() - 8.0);
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(endX - rX, endY - rY) - this.getGunHeadingRadians())));
            this.setFire(2.0);
        }
    }

    private double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public void onStatus(StatusEvent e) {
        this.out.println("ONSTATUS");
        if (this.mRadar != null) {
            this.mRadar.onTick(e.getTime());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onPaint(Graphics2D g) {
    }
}

