/*
 * Decompiled with CFR 0.152.
 */
package deo;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class FlowerBot
extends AdvancedRobot {
    private static final double MAX_DISTANCE = 1000.0;
    static final double A_LITTLE_LESS_THAN_HALF_PI = 1.25;
    int direction = 1;
    final double BULLET_POWER = 1.9;
    int distanceIndex;
    int velocityIndex;
    int lastVelocityIndex;
    double lastVelocityReal = 0.0;
    public static int BINS = 47;
    public static double[][][][] _surfStats = new double[5][5][5][BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    double[] currentWaves;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    static double direction1 = 1.0;
    static StringBuffer history = new StringBuffer("00000000000000000000000000000");
    static final double APPROACHANGLE = -0.3490658503988659;
    static final double NINTYDEG = 1.5707963267948966;
    static final double FIREPOWER = 2.5;
    static final double BULLETVEL = 12.5;
    static final int PATTERN_DEPTH = 30;
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;

    public void run() {
        this.setColors(Color.yellow, Color.red, Color.blue, Color.white, Color.green);
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int index;
        this.setSegmentations(e.getDistance(), e.getVelocity(), this.lastVelocityReal);
        this.currentWaves = _surfStats[this.distanceIndex][this.velocityIndex][this.lastVelocityIndex];
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = FlowerBot.bulletVelocity(bulletPower);
            ew.distanceTraveled = FlowerBot.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = FlowerBot.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        double dist = e.getDistance();
        double absB = e.getBearingRadians() + this.getHeadingRadians();
        int matchLenght = 30;
        history.insert(0, (char)(Math.sin(e.getHeadingRadians() - absB) * e.getVelocity()));
        while ((index = history.toString().indexOf(history.substring(0, matchLenght--), 1)) < 0) {
        }
        matchLenght = index - (int)(dist / 12.5);
        do {
            absB += Math.asin((double)((byte)history.charAt(index--)) / dist);
        } while (index >= Math.max(0, matchLenght));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absB - this.getGunHeadingRadians())));
        this.setFire(2.5);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(FlowerBot.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = FlowerBot.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / FlowerBot.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)FlowerBot.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = FlowerBot.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            this.currentWaves[n] = this.currentWaves[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(FlowerBot.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, FlowerBot.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.25, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + FlowerBot.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = FlowerBot.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = FlowerBot.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = FlowerBot.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return this.currentWaves[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = FlowerBot.absoluteBearing(surfWave.fireLocation, this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        FlowerBot.setBackAsFront(this, goAngle);
    }

    public double absbearing(double bearingRadians) {
        return this.getHeadingRadians() + bearingRadians;
    }

    public double getEnemyX(double x, double absbearing, double distance) {
        return x + Math.sin(absbearing) * distance;
    }

    public double getEnemyY(double y, double absbearing, double distance) {
        return y + Math.cos(absbearing) * distance;
    }

    public void setSegmentations(double distance, double velocity, double lastVelocity) {
        this.distanceIndex = (int)(distance / 200.0);
        this.velocityIndex = (int)Math.abs(velocity / 2.0);
        this.lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(FlowerBot.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }
}

