/*
 * Decompiled with CFR 0.152.
 */
package ethdsy;

import ethdsy.Malacka;

public abstract class MoveStrategy {
    Malacka me;
    double damage;
    private double[] bullets = new double[10];
    private int bulletIndex;
    double stat;
    int nb;
    double chances = 100.0;

    public void setup(Malacka malacka) {
        this.me = malacka;
    }

    public void resetDamage() {
        this.damage = 0.0;
        int n = 0;
        while (n < this.bullets.length) {
            this.bullets[n] = 0.0;
            ++n;
        }
    }

    public double getDamage() {
        return this.damage;
    }

    public void incDamage(double d) {
        double d2 = this.damageFromPower(d);
        this.damage += d2;
        this.damage -= this.bullets[this.bulletIndex];
        this.bullets[this.bulletIndex] = d2;
        ++this.bulletIndex;
        if (this.bulletIndex >= this.bullets.length) {
            this.bulletIndex = 0;
        }
    }

    public void decDamage(double d) {
        double d2 = this.damageFromPower(d);
        this.damage -= d2;
        this.damage -= this.bullets[this.bulletIndex];
        this.bullets[this.bulletIndex] = -d2;
        ++this.bulletIndex;
        if (this.bulletIndex >= this.bullets.length) {
            this.bulletIndex = 0;
        }
    }

    private double damageFromPower(double d) {
        double d2 = 4.0 * d;
        if (d > 1.0) {
            d2 += 2.0 * (d - 1.0);
        }
        return d2;
    }

    public boolean isChangeNeeded() {
        return this.damage > 20.0;
    }

    public abstract void doMove();
}

