/*
 * Decompiled with CFR 0.152.
 */
package ak;

import ak.Fermat;
import ak.LogData;
import ak.OtherBot;
import java.awt.geom.Point2D;

public class FiringStrategy {
    public static int count = 32;
    double[] velocities = new double[10];
    double[] headingChanges = new double[10];
    int countVelocities;
    int countHeadingChanges;

    public Point2D.Double applyStrategy(int strategyID, OtherBot bot, double firePower, Fermat robot) {
        if (strategyID < this.countVelocities) {
            return FiringStrategy.Linear(bot, firePower, robot, this.velocities[strategyID]);
        }
        if (strategyID < this.countVelocities + this.countVelocities * this.countHeadingChanges) {
            return FiringStrategy.Circular(bot, firePower, robot, this.headingChanges[(strategyID - this.countVelocities) / this.countVelocities], this.velocities[(strategyID - this.countVelocities) % this.countVelocities]);
        }
        if (strategyID == this.countVelocities + this.countVelocities * this.countHeadingChanges) {
            return FiringStrategy.PatternFire(bot, firePower, robot);
        }
        return new Point2D.Double(bot.X, bot.Y);
    }

    static Point2D.Double Linear(OtherBot bot, double firePower, Fermat robot, double velocity) {
        if (bot.energy <= 0.0) {
            return new Point2D.Double(-1.0, -1.0);
        }
        Point2D.Double p = new Point2D.Double(bot.X, bot.Y);
        if (velocity * bot.velocity < 0.0) {
            velocity *= -1.0;
        }
        int i = 0;
        while (i < 10) {
            long nextTime = Math.round(Math.sqrt((robot.getX() - p.x) * (robot.getX() - p.x) + (robot.getY() - p.y) * (robot.getY() - p.y)) / (20.0 - (double)3 * firePower));
            long time = robot.getTime() + nextTime;
            double diff = time - bot.scanTime;
            p.x = bot.X + Math.sin(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading))) * velocity * diff;
            p.y = bot.Y + Math.cos(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading))) * velocity * diff;
            ++i;
        }
        if (p.x <= 0.0 || p.x >= robot.getBattleFieldWidth() || p.y <= 0.0 || p.y >= robot.getBattleFieldHeight()) {
            return new Point2D.Double(-1.0, -1.0);
        }
        return p;
    }

    static Point2D.Double Circular(OtherBot bot, double firePower, Fermat robot, double headingChange, double velocity) {
        if (Math.abs(bot.headingChange) < 1.0E-5) {
            return new Point2D.Double(-1.0, -1.0);
        }
        if (bot.energy <= 0.0) {
            return new Point2D.Double(-1.0, -1.0);
        }
        Point2D.Double p = new Point2D.Double(bot.X, bot.Y);
        if (velocity * bot.velocity < 0.0) {
            velocity *= -1.0;
        }
        if (headingChange * bot.headingChange < 0.0) {
            headingChange *= -1.0;
        }
        int i = 0;
        while (i < 10) {
            long nextTime = Math.round(Math.sqrt((robot.getX() - p.x) * (robot.getX() - p.x) + (robot.getY() - p.y) * (robot.getY() - p.y)) / (20.0 - (double)3 * firePower));
            long time = robot.getTime() + nextTime;
            double diff = time - bot.scanTime;
            double tothead = Math.toDegrees(diff * headingChange);
            double radius = velocity / headingChange;
            p.y = bot.Y + Math.sin(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading + tothead))) * radius - Math.sin(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading))) * radius;
            p.x = bot.X + Math.cos(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading))) * radius - Math.sin(Math.toRadians(FiringStrategy.normalRelativeAngle(bot.heading + tothead))) * radius;
            ++i;
        }
        if (p.x <= 0.0 || p.x >= robot.getBattleFieldWidth() || p.y <= 0.0 || p.y >= robot.getBattleFieldHeight()) {
            return new Point2D.Double(-1.0, -1.0);
        }
        return p;
    }

    static double findGunTurn(double x, double y, Fermat robot) {
        double angle = FiringStrategy.normalAbsoluteHeading(Math.toDegrees(1.5707963267948966 - Math.atan2(robot.getY() - y, robot.getX() - x)));
        return FiringStrategy.normalRelativeAngle(robot.getGunHeading() - angle + 180.0);
    }

    static Point2D.Double PatternFire(OtherBot bot, double firePower, Fermat robot) {
        long lastScanTime = bot.scanTime;
        double minDiff = 1.0E30;
        long bestPatternTime = -1;
        long nextTime = Math.round(Math.sqrt((robot.getX() - bot.X) * (robot.getX() - bot.X) + (robot.getY() - bot.Y) * (robot.getY() - bot.Y)) / (20.0 - (double)3 * firePower));
        long patternEndTime = lastScanTime - nextTime - 1L;
        while (patternEndTime >= bot.logStartTime + (long)4) {
            double diff = 0.0;
            long j = 0L;
            while (j < 10L) {
                LogData currData = (LogData)bot.logTable.get(new Integer((int)(lastScanTime - j)));
                LogData prevData = (LogData)bot.logTable.get(new Integer((int)(patternEndTime - j)));
                if (currData == null || prevData == null) break;
                diff += Math.abs(currData.headingChange - prevData.headingChange);
                diff += 11.0 * Math.abs(currData.velocity - prevData.velocity);
                if (j > (long)3 && diff / (double)(j + 1L) < minDiff) {
                    minDiff = diff / (double)(j + 1L);
                    bestPatternTime = patternEndTime;
                }
                ++j;
            }
            --patternEndTime;
        }
        if (bestPatternTime == (long)-1 || minDiff > 0.2) {
            return new Point2D.Double(-1.0, -1.0);
        }
        Point2D.Double p = new Point2D.Double(bot.X, bot.Y);
        int i = 0;
        while (i < 10) {
            nextTime = Math.round(Math.sqrt((robot.getX() - p.x) * (robot.getX() - p.x) + (robot.getY() - p.y) * (robot.getY() - p.y)) / (20.0 - (double)3 * firePower));
            long rtime = robot.getTime() + nextTime;
            p.x = bot.X;
            p.y = bot.Y;
            double heading = bot.heading;
            long time = bestPatternTime;
            while (time < bestPatternTime + rtime - lastScanTime) {
                LogData data = (LogData)bot.logTable.get(new Integer((int)time));
                if (data == null) {
                    return new Point2D.Double(-1.0, -1.0);
                }
                double headingChange = data.headingChange;
                double velocity = data.velocity;
                p.x += Math.sin(Math.toRadians(FiringStrategy.normalRelativeAngle(heading))) * velocity;
                p.y += Math.cos(Math.toRadians(FiringStrategy.normalRelativeAngle(heading))) * velocity;
                heading = FiringStrategy.normalRelativeAngle(Math.toDegrees(headingChange) + heading);
                ++time;
            }
            ++i;
        }
        if (p.x <= 0.0 || p.x >= robot.getBattleFieldWidth() || p.y <= 0.0 || p.y >= robot.getBattleFieldHeight()) {
            return new Point2D.Double(-1.0, -1.0);
        }
        return p;
    }

    public static double normalAbsoluteHeading(double angle) {
        if (angle < 0.0) {
            return 360.0 + angle % 360.0;
        }
        return angle % 360.0;
    }

    public static double normalRelativeAngle(double angle) {
        if (angle > 180.0) {
            return (angle + 180.0) % 360.0 - 180.0;
        }
        if (angle < -180.0) {
            return (angle - 180.0) % 360.0 + 180.0;
        }
        return angle;
    }

    FiringStrategy(OtherBot bot) {
        this.velocities[0] = bot.velocity;
        this.velocities[1] = bot.avgVelocity;
        this.velocities[2] = bot.avgStopVelocity;
        this.velocities[3] = bot.rollingAvgVelocity;
        this.velocities[4] = bot.rollingAvgStopVelocity;
        this.countVelocities = 5;
        this.headingChanges[0] = bot.headingChange;
        this.headingChanges[1] = bot.avgHeadingChange;
        this.headingChanges[2] = bot.avgStraightHeadingChange;
        this.headingChanges[3] = bot.rollingAvgHeadingChange;
        this.headingChanges[4] = bot.rollingAvgStraightHeadingChange;
        this.countHeadingChanges = 5;
    }
}

