/*
 * Decompiled with CFR 0.152.
 */
package lunchie;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import lunchie.Log;
import lunchie.Position;
import lunchie.RobotEvent;
import lunchie.RobotInfo;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitRobotEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class MatchInfo {
    static AdvancedRobot robot;
    private static final String classname = "MatchInfo";
    Hashtable nameMap = new Hashtable();
    RobotInfo[] enemies;
    int enemyCount = 0;

    public void record() {
        RobotEvent be;
        HitRobotEvent e;
        Position here = new Position();
        Vector events = robot.getHitRobotEvents();
        int i = 0;
        while (i < events.size()) {
            e = (HitRobotEvent)events.get(i);
            be = new RobotEvent(e, here, robot);
            this.enemies[this.getNameIndex(e.getName())].addBotEvent(be);
            ++i;
        }
        events = robot.getScannedRobotEvents();
        i = 0;
        while (i < events.size()) {
            e = (ScannedRobotEvent)events.get(i);
            be = new RobotEvent((ScannedRobotEvent)e, here, robot);
            int ix = this.getNameIndex(e.getName());
            this.enemies[ix].addBotEvent(be);
            ++i;
        }
        events = robot.getRobotDeathEvents();
        i = 0;
        while (i < events.size()) {
            e = (RobotDeathEvent)events.get(i);
            this.enemies[this.getNameIndex(e.getName())].hasDied();
            ++i;
        }
    }

    public RobotInfo getTarget(RobotInfo lastTarget) {
        if (lastTarget != null && lastTarget.alive() && (lastTarget.lastEvent().energy < 10.0 || lastTarget.lastEvent().range < 350.0)) {
            return lastTarget;
        }
        double bestDist = Position.ArenaMaxDist;
        int targIdx = -1;
        int b = 0;
        while (b < this.enemyCount) {
            if (this.enemies[b].alive()) {
                if (this.enemies[b].lastEvent().energy <= 5.0) {
                    return this.enemies[b];
                }
                if (this.enemies[b].lastEvent().range < bestDist) {
                    bestDist = this.enemies[b].lastEvent().range;
                    targIdx = b;
                }
            }
            ++b;
        }
        if (targIdx >= 0 && bestDist < 1000.0) {
            return this.enemies[targIdx];
        }
        return null;
    }

    public boolean isEveryoneScanned() {
        return robot.getOthers() == this.enemyCount;
    }

    public void init() {
        int b = 0;
        while (b < this.enemyCount) {
            this.enemies[b].init();
            ++b;
        }
    }

    private final int getNameIndex(String name) {
        int index = -1;
        if (this.nameMap.containsKey(name)) {
            index = (Integer)this.nameMap.get(name);
            Log.print(3, classname, "getNameIndex", "Found " + name + ": idx=" + index);
        } else {
            index = this.enemyCount++;
            Log.print(3, classname, "getNameIndex", "Adding " + name + ": idx=" + index);
            Integer indexObj = new Integer(index);
            if (this.enemies[index] == null) {
                this.enemies[index] = new RobotInfo();
            }
            this.enemies[index].init(name);
            this.nameMap.put(name, indexObj);
        }
        return index;
    }

    public void dumpContentsToFile(String fileName) {
        try {
            PrintStream w = new PrintStream((OutputStream)new RobocodeFileOutputStream(robot.getDataFile(fileName)));
            this.dump(w);
            if (w.checkError()) {
                System.out.println("Failed while writing to " + fileName);
            }
            w.close();
        }
        catch (IOException e) {
            System.out.print("Failed to open " + fileName + " file: ");
            System.out.println(e.getMessage());
        }
    }

    public void dump(PrintStream ostr) {
        int e = 0;
        while (e < this.enemyCount) {
            this.enemies[e].dump(ostr);
            ++e;
        }
    }

    public MatchInfo(AdvancedRobot r) {
        this.enemies = new RobotInfo[r.getOthers()];
        this.enemyCount = 0;
        robot = r;
        r.addCustomEvent(new Condition(this, classname){
            private final /* synthetic */ MatchInfo this$0;

            public final boolean test() {
                this.this$0.record();
                return true;
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(MatchInfo matchInfo, String $1) {
            }
        });
    }
}

