/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules;

import ghent.common.Direction;
import ghent.common.Target;
import ghent.modules.EventDispatcher;
import ghent.modules.detection.events.DetectFireCondition;
import ghent.modules.detection.events.DetectTargetCondition;
import ghent.modules.navigation.events.NearWallCondition;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.robotinterfaces.IAdvancedEvents;
import robocode.robotinterfaces.IBasicEvents;

public abstract class EventRobot
extends AdvancedRobot {
    private EventDispatcher _eventDispatcher = new EventDispatcher();

    public final void addEventsListener(Object listener) {
        if (listener instanceof IBasicEvents) {
            this._eventDispatcher.addBasicEventsListener((IBasicEvents)listener);
        }
        if (listener instanceof IAdvancedEvents) {
            this._eventDispatcher.addAdvancedEventsListener((IAdvancedEvents)listener);
        }
    }

    public final void onScannedRobot(ScannedRobotEvent event) {
        this._eventDispatcher.fireScannedRobot(event);
        this.onScannedRobotCustom(event);
    }

    public void onScannedRobotCustom(ScannedRobotEvent event) {
    }

    public final void onBulletHit(BulletHitEvent event) {
        this._eventDispatcher.fireBulletHit(event);
        this.onBulletHitCustom(event);
    }

    public void onBulletHitCustom(BulletHitEvent event) {
    }

    public final void onHitByBullet(HitByBulletEvent event) {
        this._eventDispatcher.fireHitByBullet(event);
        this.onHitByBulletCustom(event);
    }

    public void onHitByBulletCustom(HitByBulletEvent event) {
    }

    public final void onBulletMissed(BulletMissedEvent event) {
        this._eventDispatcher.fireBulletMissed(event);
        this.onBulletMissedCustom(event);
    }

    public void onBulletMissedCustom(BulletMissedEvent event) {
    }

    public final void onHitRobot(HitRobotEvent event) {
        this._eventDispatcher.fireHitRobot(event);
        this.onHitRobotCustom(event);
    }

    public void onHitRobotCustom(HitRobotEvent event) {
    }

    public final void onHitWall(HitWallEvent event) {
        this._eventDispatcher.fireHitWall(event);
        this.onHitWallCustom(event);
    }

    public void onHitWallCustom(HitWallEvent event) {
    }

    public final void onRobotDeath(RobotDeathEvent event) {
        this._eventDispatcher.fireRobotDeath(event);
        this.onRobotDeathCustom(event);
    }

    public void onRobotDeathCustom(RobotDeathEvent event) {
    }

    public final void onWin(WinEvent event) {
        this._eventDispatcher.fireWin(event);
        this.onWinCustom(event);
    }

    public void onWinCustom(WinEvent event) {
    }

    public void onCustomEvent(CustomEvent event) {
        this._eventDispatcher.fireCustomEvent(event);
        if (event.getCondition() instanceof DetectFireCondition) {
            DetectFireCondition dfc = (DetectFireCondition)event.getCondition();
            this.onDetectFire(dfc.getTarget());
        } else if (event.getCondition() instanceof DetectTargetCondition) {
            DetectTargetCondition dtc = (DetectTargetCondition)event.getCondition();
            this.onDetectRobot(dtc.getTarget());
        } else if (event.getCondition() instanceof NearWallCondition) {
            NearWallCondition nwc = (NearWallCondition)event.getCondition();
            this.onNearWall(nwc.getDirection());
        }
    }

    public void onDetectFire(Target target) {
    }

    public void onDetectRobot(Target target) {
    }

    public void onNearWall(Direction direction) {
    }

    public final void onStatus(StatusEvent event) {
        this._eventDispatcher.fireStatus(event);
        this.onStatusCustom(event);
    }

    public void onStatusCustom(StatusEvent event) {
    }

    public final void onBulletHitBullet(BulletHitBulletEvent event) {
        this._eventDispatcher.fireBulletHitBullet(event);
        this.onBulletHitBulletCustom(event);
    }

    public void onBulletHitBulletCustom(BulletHitBulletEvent event) {
    }

    public final void onDeath(DeathEvent event) {
        this._eventDispatcher.fireDeath(event);
        this.onDeathCustom(event);
    }

    public void onDeathCustom(DeathEvent event) {
    }

    public final void onSkippedTurn(SkippedTurnEvent event) {
        this._eventDispatcher.fireSkippedTurn(event);
        this.onSkippedTurnCustom(event);
    }

    public void onSkippedTurnCustom(SkippedTurnEvent event) {
    }
}

