/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.detection;

import ghent.common.Target;
import ghent.modules.Module;
import ghent.modules.detection.TargetFactory;
import ghent.modules.detection.events.DetectFireCondition;
import ghent.modules.detection.events.DetectTargetCondition;
import ghent.modules.detection.strategies.ILockRadarStrategy;
import ghent.modules.detection.strategies.IMeleeRadarStrategy;
import ghent.modules.detection.strategies.SpinningRadarStrategy;
import ghent.modules.detection.strategies.TurnMultiplierRadarStrategy;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Radar
extends Module {
    private final ILockRadarStrategy _lockRadarStrategy;
    private final IMeleeRadarStrategy _meleeRadarStrategy;
    protected Map<String, Target> _others;
    private Target _lock;

    public Radar(AdvancedRobot robot) {
        super(robot);
        this._lockRadarStrategy = new TurnMultiplierRadarStrategy(robot);
        this._meleeRadarStrategy = new SpinningRadarStrategy(robot);
        this._others = new HashMap<String, Target>(5);
        this._lock = null;
    }

    protected final void fireDetectFire(Target target, double bPower) {
        this._robot.addCustomEvent((Condition)new DetectFireCondition(target, bPower, this._robot));
    }

    protected final void fireDetectRobot(Target target) {
        this._robot.addCustomEvent((Condition)new DetectTargetCondition(target, this._robot));
    }

    public void turnLeft(double degree) {
        this._robot.setTurnRadarLeft(degree);
    }

    public void turnRight(double degree) {
        this._robot.setTurnRadarRight(degree);
    }

    public void scan() {
        if (this._others.size() > this._robot.getOthers()) {
            this._others.clear();
        }
        this._meleeRadarStrategy.scan();
    }

    public void setLock(Target target) {
        this._lock = target;
    }

    public void unlock() {
        if (this._robot.getOthers() > 1) {
            this._lock = null;
        }
    }

    public boolean isLocked() {
        return this._lock != null;
    }

    public boolean isLockedOn(Target target) {
        if (target == null) {
            return !this.isLocked();
        }
        return this.isLocked() && this._lock.getName().equals(target.getName());
    }

    public boolean isLockedOn(String name) {
        if (name == null) {
            return !this.isLocked();
        }
        return this.isLocked() && this._lock.getName().equals(name);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        Target target = this.getTargetByName(e.getName());
        if (target != null) {
            double bulletPower = target.getEnergy() - e.getEnergy();
            if (bulletPower > 0.0 && bulletPower <= 3.0) {
                this.fireDetectFire(target, bulletPower);
            }
            target = TargetFactory.updateTarget(this._robot, target, e);
        } else {
            target = TargetFactory.createTarget(this._robot, e);
        }
        this._others.put(target.getName(), target);
        this.fireDetectRobot(target);
        if (!this.isLocked() && this._robot.getOthers() == 1) {
            this.setLock(target);
        }
        if (this.isLockedOn(target)) {
            this._lockRadarStrategy.scan(target);
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        Target target = this.getTargetByName(e.getName());
        if (target == null) {
            target = TargetFactory.createTarget(this._robot, e);
            this._others.put(target.getName(), target);
        } else {
            target = TargetFactory.updateTarget(this._robot, target, e);
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        if (e.getEnergy() <= 0.0) {
            this.removeTarget(e.getName());
        } else {
            Target target = this.getTargetByName(e.getName());
            if (target == null) {
                target = TargetFactory.createTarget(this._robot, e);
                this._others.put(target.getName(), target);
            } else {
                Target target2 = TargetFactory.updateTarget(this._robot, target, e);
            }
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        Target target = this.getTargetByName(event.getName());
        if (target != null) {
            TargetFactory.updateTarget(this._robot, target, event);
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        super.onRobotDeath(e);
        this.removeTarget(e.getName());
    }

    private void removeTarget(String name) {
        this._others.remove(name);
        if (this.isLockedOn(name)) {
            this.unlock();
        }
    }

    public Map<String, Target> getTargets() {
        return this._others;
    }

    public Target getTargetByName(String targetname) {
        return this._others.get(targetname);
    }
}

