/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.Configuration;
import florent.XSeries.gun.GunFactory;
import florent.XSeries.gun.GunStrategy;
import florent.XSeries.gun.GunType;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;

public class FatalityMovement
extends MovementStrategy {
    private Xmen me;
    private GunStrategy gun;
    private boolean goingAway;
    private int score;
    private int timeSinceGoingCloser;

    public FatalityMovement(Xmen me) {
        this.me = me;
        this.gun = GunFactory.getInstance().getStrategy(GunType.FATALITYGUN);
        this.gun.holdFire = true;
    }

    public void initRound() {
        this.gun.holdFire = true;
        this.goingAway = true;
        this.timeSinceGoingCloser = -1;
    }

    public void onMainLoop() {
        Enemy enemy = TargetSelector.getInstance(this.me, Tracker.getInstance()).getTarget();
        if (!this.goingAway && enemy != null) {
            this.gun.holdFire = false;
        }
        if (!this.goingAway) {
            ++this.timeSinceGoingCloser;
        }
        Point2D.Double myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        Point2D.Double destination = Configuration.Center;
        if (!this.goingAway && enemy != null && enemy.location != null && this.timeSinceGoingCloser > 2) {
            destination = enemy.location;
            this.gun.holdFire = false;
        }
        if (this.goingAway && enemy != null && enemy.location != null && ((destination = Configuration.fartherCorner(enemy.location)).distance(myLocation) < 10.0 || enemy.location.distance(myLocation) + 45.0 > 1200.0)) {
            this.goingAway = false;
        }
        double theta = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), destination) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    public void execCondition() {
        Enemy enemy = TargetSelector.getInstance(this.me, Tracker.getInstance()).getTarget();
        this.score = enemy != null && enemy.energy == 0.0 && enemy.velocity == 0.0 ? 75 : 0;
    }

    public int getScore() {
        return this.score;
    }
}

