/*
 * Decompiled with CFR 0.152.
 */
package amc;

import java.awt.Point;
import java.awt.geom.Point2D;
import robocode.util.Utils;

class BulletWave {
    private static Point2D targetLocation = new Point();
    private Point2D center;
    private double startBearing;
    private double bulletPower;
    private long fireTime;
    private short direction;
    private int[] returnSegment;

    public BulletWave(int x, int y, double bearing, double bulletPower, short direction, long time, int[] segment) {
        this.center = new Point(x, y);
        this.startBearing = bearing;
        this.bulletPower = bulletPower;
        this.direction = direction;
        this.fireTime = time;
        this.returnSegment = segment;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getBulletSpeed() {
        return 20.0 - this.bulletPower * 3.0;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public double getDistanceTraveled(long time) {
        return (double)(time - this.fireTime) * this.getBulletSpeed();
    }

    public static void setTargetLocation(int enemyX, int enemyY) {
        targetLocation.setLocation(enemyX, enemyY);
    }

    public boolean checkResult(long time) {
        if (this.center.distance(targetLocation) <= this.getDistanceTraveled(time)) {
            int index;
            double desiredBearing = Math.atan2(targetLocation.getX() - this.center.getX(), targetLocation.getY() - this.center.getY());
            double angleOffset = Utils.normalRelativeAngle((double)(desiredBearing - this.startBearing));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this.direction;
            int n = index = (int)Math.round((double)((this.returnSegment.length - 1) / 2) * (guessFactor + 1.0));
            this.returnSegment[n] = this.returnSegment[n] + 1;
            return true;
        }
        return false;
    }
}

