/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import divineomega.GFTWave;
import divineomega.GunManager;
import divineomega.MovementMode;
import divineomega.patternmatching.PatternMatchingManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.RobocodeFileOutputStream;

public abstract class FileManager {
    public static void load(File file) {
        DivineBot.output("Loading from '" + file.getAbsolutePath() + "'...");
        if (!file.exists()) {
            DivineBot.output("File does not exist yet.");
            return;
        }
        if (!file.canRead()) {
            DivineBot.output("Can not read from file.");
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ZipInputStream zis = new ZipInputStream(fis);
            zis.getNextEntry();
            ObjectInputStream ois = new ObjectInputStream(zis);
            GunManager.setEnemyNameToGunList((HashMap)ois.readObject());
            MovementMode.setModeData((HashMap)ois.readObject());
            MovementMode.setWins((HashMap)ois.readObject());
            MovementMode.setRounds((HashMap)ois.readObject());
            DivineBot.gunAngles = (HashMap)ois.readObject();
            DivineBot.bulletShieldFailureCount = (HashMap)ois.readObject();
            PatternMatchingManager.history = (HashMap)ois.readObject();
            GFTWave.enemyNameToStatBuffer = (HashMap)ois.readObject();
            ois.close();
            DivineBot.output("Loading complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
            DivineBot.output("Error loading file. New file will be created at the end of the round.");
        }
    }

    public static void save(File file) {
        DivineBot.output("Saving to '" + file.getAbsolutePath() + "'...");
        try {
            RobocodeFileOutputStream fos = new RobocodeFileOutputStream(file);
            ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
            zos.putNextEntry(new ZipEntry(file.getName()));
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(GunManager.getEnemyNameToGunList());
            oos.writeObject(MovementMode.getModeData());
            oos.writeObject(MovementMode.getWins());
            oos.writeObject(MovementMode.getRounds());
            oos.writeObject(DivineBot.gunAngles);
            oos.writeObject(DivineBot.bulletShieldFailureCount);
            oos.writeObject(PatternMatchingManager.history);
            oos.writeObject(GFTWave.enemyNameToStatBuffer);
            oos.flush();
            zos.closeEntry();
            oos.close();
            DivineBot.output("Saving complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void quotaCheck(long dataQuotaAvailable, File dataDirectory) {
        DivineBot.output("Checking data quota...");
        if (dataQuotaAvailable <= 0L) {
            File[] filesToDelete;
            DivineBot.output("Over quota! Looking up files...");
            File[] fileArray = filesToDelete = dataDirectory.listFiles();
            int n = filesToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                File fileToDelete = fileArray[n2];
                DivineBot.output("Deleting file '" + fileToDelete.getAbsolutePath() + "'...");
                fileToDelete.delete();
                ++n2;
            }
        }
        DivineBot.output("Quota check complete.");
    }

    public static void deleteUnnecessary(File dataFile, File dataDirectory) {
        File[] filesToDelete;
        DivineBot.output("Checking for unnecessary files...");
        File[] fileArray = filesToDelete = dataDirectory.listFiles();
        int n = filesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            File fileToDelete = fileArray[n2];
            if (!fileToDelete.getAbsolutePath().equals(dataFile.getAbsolutePath())) {
                DivineBot.output("Deleting unnecessary '" + fileToDelete.getAbsolutePath() + "'...");
                fileToDelete.delete();
            }
            ++n2;
        }
        DivineBot.output("Unnecessary file check complete.");
    }
}

