/*
 * Decompiled with CFR 0.152.
 */
package rdt199.gun;

import rdt199.Mode;
import rdt199.gun.ShootingLocation;
import rdt199.tracking.VirtualBullet;
import rdt199.util.BotFuncs;
import rdt199.util.FileHandler;
import rdt199.util.Location;
import rdt199.util.RobotLog;

public abstract class GunMode
extends Mode {
    protected String m_Prefix;
    protected int m_iActualShots;
    protected int m_iActualHits;
    protected double m_dVirtualAverage;
    protected RobotLog m_Log;
    protected ShootingLocation m_PredictedLocation;
    protected static double N = 40.0;

    public GunMode(RobotLog log) {
        this.m_Log = log;
    }

    public GunMode(RobotLog log, String prefix) {
        this.m_Log = log;
        this.m_iActualShots = 0;
        this.m_iActualHits = 0;
        this.m_dVirtualAverage = 0.5;
        this.m_Prefix = prefix;
    }

    public void update() {
    }

    public void setActualHit(boolean hit) {
        if (hit) {
            ++this.m_iActualHits;
        }
        ++this.m_iActualShots;
    }

    public void setVirtualHit(VirtualBullet bullet) {
        double dHit = 0.0;
        if (bullet.hitTarget()) {
            dHit = 1.0;
        }
        this.m_dVirtualAverage = (this.m_dVirtualAverage * N + dHit * bullet.getFirepower()) / (N + bullet.getFirepower());
    }

    public void calcPredictedLocation(Location sloc, double firepower) {
        if (this.m_Log == null || !this.m_Log.isAlive()) {
            this.m_PredictedLocation = null;
            return;
        }
        double dDistance = BotFuncs.getDistanceBetween(this.m_Log.get((int)0).m_Location, sloc);
        this.m_PredictedLocation = this.getIterativePrediction(sloc, firepower, dDistance);
    }

    public ShootingLocation getPredictedLocation() {
        return this.m_PredictedLocation;
    }

    public void fireVirtualBullet(Location sloc) {
        if (this.m_PredictedLocation == null) {
            return;
        }
        if (!this.readyToFire(this.m_PredictedLocation)) {
            return;
        }
        if (!BotFuncs.isInBattlefield(this.m_PredictedLocation)) {
            this.setVirtualMiss();
            return;
        }
        double dAngle = Math.toDegrees(BotFuncs.getAbsBearing(this.m_PredictedLocation, sloc));
        VirtualBullet b = new VirtualBullet(dAngle, this.m_PredictedLocation.dFirepower, sloc, BotFuncs.getTarget(), this);
    }

    protected void loadData(String element) {
        String VAverage;
        String AHits;
        FileHandler FH = this.m_Log.getFileHandler();
        String AShots = FH.getItem(element, "ashots");
        if (AShots != null) {
            this.m_iActualShots = Integer.valueOf(AShots);
        }
        if ((AHits = FH.getItem(element, "ahits")) != null) {
            this.m_iActualHits = Integer.valueOf(AHits);
        }
        if ((VAverage = FH.getItem(element, "va")) != null) {
            this.m_dVirtualAverage = Double.valueOf(VAverage);
        }
    }

    protected void saveData(String element) {
        FileHandler FH = this.m_Log.getFileHandler();
        FH.addItem(element, "ashots", String.valueOf(this.m_iActualShots));
        FH.addItem(element, "ahits", String.valueOf(this.m_iActualHits));
        FH.addItem(element, "va", String.valueOf(this.m_dVirtualAverage));
    }

    protected abstract Location getPrediction(long var1);

    protected ShootingLocation getIterativePrediction(Location sloc, double firepower, double initialdistance) {
        if (this.m_Log != null) {
            double dDistance = initialdistance;
            long lTimeToImpact = this.getBulletTimeToImpact(firepower, dDistance);
            Location PredictedLoc = null;
            int iCount = 0;
            while (iCount < 5) {
                long lOldTimeGuess = lTimeToImpact;
                PredictedLoc = this.getPrediction(lTimeToImpact);
                if (PredictedLoc == null) {
                    return null;
                }
                dDistance = BotFuncs.getDistanceBetween(PredictedLoc, sloc);
                lTimeToImpact = this.getBulletTimeToImpact(firepower, dDistance);
                if (lTimeToImpact == lOldTimeGuess) break;
                ++iCount;
            }
            return new ShootingLocation(PredictedLoc.getX(), PredictedLoc.getY(), firepower);
        }
        return null;
    }

    protected double getPercentage() {
        return this.m_dVirtualAverage;
    }

    protected long getBulletTimeToImpact(double firepower, double distance) {
        double dTime = distance / this.getBulletVelocity(firepower);
        return (long)dTime;
    }

    protected double getBulletVelocity(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    protected boolean readyToFire(ShootingLocation loc) {
        if (loc == null) {
            return false;
        }
        if (loc.dFirepower < 0.0) {
            return false;
        }
        if (BotFuncs.m_AdvancedRobot.getGunHeat() != 0.0) {
            return false;
        }
        return !(BotFuncs.m_AdvancedRobot.getGunTurnRemaining() >= 2.0);
    }

    protected void setVirtualMiss() {
        this.m_dVirtualAverage = this.m_dVirtualAverage * N / (N + 1.0);
    }
}

