/*
 * Decompiled with CFR 0.152.
 */
package rdt199.gun;

import rdt199.gun.GunMode;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;

public class HalfVelocityCircularMode
extends GunMode {
    public HalfVelocityCircularMode(RobotLog log) {
        super(log);
    }

    public HalfVelocityCircularMode(RobotLog log, String prefix) {
        super(log, prefix);
        this.loadData(String.valueOf(this.m_Prefix) + "hvcirc");
    }

    public double getScore() {
        return this.getPercentage();
    }

    public void close() {
        this.saveData(String.valueOf(this.m_Prefix) + "hvcirc");
    }

    protected Location getPrediction(long time) {
        RobotSnapshot Snap = this.m_Log.get(0);
        if (Snap != null) {
            double dVelocity = Snap.m_dVelocity;
            if (dVelocity == 0.0) {
                return Snap.m_Location;
            }
            double dDeltaX = 0.0;
            double dDeltaY = 0.0;
            double dHeading = Snap.m_dAngle;
            int iCount = 0;
            while (iCount < (int)time) {
                dDeltaX += dVelocity / 2.0 * Math.sin(Math.toRadians(dHeading += Snap.m_dDeltaAngle));
                dDeltaY += dVelocity / 2.0 * Math.cos(Math.toRadians(dHeading));
                ++iCount;
            }
            return new Location(Snap.m_Location.getX() + dDeltaX, Snap.m_Location.getY() + dDeltaY);
        }
        return null;
    }
}

