/*
 * Decompiled with CFR 0.152.
 */
package rdt199.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import rdt199.util.BotFuncs;
import robocode.RobocodeFileOutputStream;

public class FileHandler {
    private String m_Filename;
    private Hashtable m_Elements;

    public FileHandler(String filename) {
        this.m_Filename = filename;
        this.m_Elements = new Hashtable(1);
        this.loadItems();
    }

    public void saveItems() {
        try {
            RobocodeFileOutputStream RFOS = new RobocodeFileOutputStream(BotFuncs.m_AdvancedRobot.getDataFile(this.m_Filename));
            PrintStream PS = new PrintStream((OutputStream)RFOS);
            this.saveElementData(PS);
            if (PS.checkError()) {
                System.out.println(" ** ERROR WRITING TO " + this.m_Filename);
            }
            PS.close();
        }
        catch (IOException e) {
            System.out.println(" ** IOEXCEPTION WRITING TO " + this.m_Filename);
        }
    }

    public void saveString(String text) {
        try {
            RobocodeFileOutputStream RFOS = new RobocodeFileOutputStream(BotFuncs.m_AdvancedRobot.getDataFile(this.m_Filename));
            PrintStream PS = new PrintStream((OutputStream)RFOS);
            PS.print(text);
            if (PS.checkError()) {
                System.out.println(" ** ERROR WRITING TO " + this.m_Filename);
            }
            PS.close();
        }
        catch (IOException e) {
            System.out.println(" ** IOEXCEPTION WRITING TO " + this.m_Filename);
        }
    }

    public void addItem(String elementname, String fieldname, String data) {
        Hashtable Field = (Hashtable)this.m_Elements.get(elementname);
        if (Field == null) {
            Field = new Hashtable(1);
            this.m_Elements.put(elementname, Field);
        }
        this.setData(Field, fieldname, data);
    }

    public String getItem(String element, String field) {
        Hashtable Field = (Hashtable)this.m_Elements.get(element);
        if (Field == null) {
            return null;
        }
        return (String)Field.get(field);
    }

    private void loadItems() {
        try {
            FileReader FR = new FileReader(BotFuncs.m_AdvancedRobot.getDataFile(this.m_Filename));
            BufferedReader BR = new BufferedReader(FR);
            String LineText = BR.readLine();
            while (LineText != null) {
                this.loadElement(LineText, BR);
                LineText = BR.readLine();
            }
        }
        catch (IOException e) {
            System.out.println(" ** IOEXCEPTION READING FROM " + this.m_Filename);
        }
    }

    private void loadElement(String element, BufferedReader reader) throws IOException {
        if (element.charAt(0) != '#') {
            return;
        }
        String[] Text = element.split("#");
        String[] Element = Text[1].split("=");
        int iElementSize = Integer.parseInt(Element[1]);
        int iCount = 0;
        while (iCount < iElementSize) {
            String Field = reader.readLine();
            if (Field == null) {
                return;
            }
            String[] Data = Field.split("=");
            this.addItem(Element[0], Data[0], Data[1]);
            ++iCount;
        }
    }

    private void setData(Hashtable field, String fieldname, String data) {
        field.put(fieldname, data);
    }

    private void saveElementData(PrintStream ps) {
        Enumeration Enum2 = this.m_Elements.keys();
        while (Enum2.hasMoreElements()) {
            String ElementName = (String)Enum2.nextElement();
            Hashtable Fields = (Hashtable)this.m_Elements.get(ElementName);
            if (Fields == null) {
                return;
            }
            ps.println("#" + ElementName + "=" + Fields.size());
            this.saveFieldData(ElementName, ps);
        }
    }

    private void saveFieldData(String elementname, PrintStream ps) {
        Hashtable Fields = (Hashtable)this.m_Elements.get(elementname);
        if (Fields == null) {
            return;
        }
        Enumeration Enum2 = Fields.keys();
        while (Enum2.hasMoreElements()) {
            String Fieldname = (String)Enum2.nextElement();
            String Data = (String)Fields.get(Fieldname);
            ps.println(String.valueOf(Fieldname) + "=" + Data);
        }
    }
}

