/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.shield;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.cat.group.shield.BulletShieldingDrive;
import xander.cat.group.shield.BulletShieldingListener;
import xander.core.Resources;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundBeginListener;
import xander.core.event.TurnListener;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class BulletShieldingController
implements RoundBeginListener,
TurnListener,
OpponentWaveListener,
MyWaveListener,
Paintable {
    private static final int REQUIRED_LEAD_TIME = 4;
    private List<Wave> waveQueue = new ArrayList<Wave>();
    private Wave nextQueueWave = null;
    private Wave waveToShieldAgainst = null;
    private Wave justAddedToQueue = null;
    private boolean opponentTooClose;
    private BulletShieldingDrive bsDrive;
    private List<WavePair> wavePairs = new ArrayList<WavePair>();
    private int bulletShieldingShots;
    private int bulletShieldingHits;
    private int rollingHits;
    private int rollingShots;
    private boolean[] rollingHitLog = new boolean[32];
    private int rollingIndex;
    private int bulletShieldingConsecutiveMisses;
    private List<BulletShieldingListener> bulletShieldingListeners = new ArrayList<BulletShieldingListener>();
    private double missDamage;

    public BulletShieldingController(BulletShieldingDrive bsDrive) {
        Resources.getRobotEvents().addRoundBeginListener(this);
        Resources.getRobotEvents().addTurnListener(this);
        Resources.getWaveHistory().addOpponentWaveListener(this);
        Resources.getWaveHistory().addMyWaveListener(this);
        this.bsDrive = bsDrive;
        Paintables.addPaintable(this);
    }

    public void addBulletShieldingListener(BulletShieldingListener listener) {
        this.bulletShieldingListeners.add(listener);
    }

    public void reset() {
        this.bsDrive.reset();
    }

    public String getDstate() {
        return this.bsDrive.getDstate();
    }

    public double getMissDamage() {
        return this.missDamage;
    }

    public double getMissDamagePerShieldingShot() {
        return this.bulletShieldingShots == 0 ? 0.0 : this.missDamage / (double)this.bulletShieldingShots;
    }

    public int getRequiredLeadTimeForOpponentWaves() {
        return 4;
    }

    public int getBulletShieldingMisses() {
        return this.bulletShieldingShots - this.bulletShieldingHits;
    }

    public int getBulletShieldingShots() {
        return this.bulletShieldingShots;
    }

    public int getBulletShieldingConsecutiveMisses() {
        return this.bulletShieldingConsecutiveMisses;
    }

    public double getBulletShieldingRatio() {
        return this.bulletShieldingHits == 0 ? 0.0 : (double)this.bulletShieldingHits / (double)this.bulletShieldingShots;
    }

    public double getRollingBulletShieldingRatio() {
        return this.rollingHits == 0 ? 0.0 : (double)this.rollingHits / (double)this.rollingShots;
    }

    public Wave requestWaveToShieldAgainst() {
        if (!this.bsDrive.isAtStandingPosition()) {
            if (this.bsDrive.isAtFiringPosition()) {
                this.bsDrive.requestMoveToStandingPosition();
            }
            return null;
        }
        this.waveToShieldAgainst = this.nextQueueWave;
        if (this.waveToShieldAgainst != null) {
            this.bsDrive.requestMoveToFiringPosition(this.waveToShieldAgainst);
            this.waveQueue.remove(this.waveToShieldAgainst);
        }
        this.nextQueueWave = null;
        return this.waveToShieldAgainst;
    }

    public boolean requestAuthorizationToFire() {
        return this.bsDrive.isAtFiringPosition();
    }

    @Override
    public void onRoundBegin() {
        this.waveQueue.clear();
        this.wavePairs.clear();
        this.nextQueueWave = null;
        this.waveToShieldAgainst = null;
        this.justAddedToQueue = null;
        this.opponentTooClose = false;
        this.bulletShieldingConsecutiveMisses = 0;
    }

    @Override
    public void onTurnBegin() {
        long closestTUH = Long.MAX_VALUE;
        Iterator<Wave> iter = this.waveQueue.iterator();
        while (iter.hasNext()) {
            Snapshot snap;
            Wave wave = iter.next();
            long tuh = wave.getTimeUntilHit((snap = wave.getInitialDefenderSnapshot()).getX(), snap.getY(), Resources.getTime());
            if (tuh - (long)RCPhysics.getTimeUntilGunCool() < (long)(4 + this.bsDrive.getMoveTimeNeededForWave(wave))) {
                iter.remove();
                if (this.nextQueueWave == wave) {
                    this.nextQueueWave = null;
                }
                if (this.justAddedToQueue != wave) continue;
                this.opponentTooClose = true;
                continue;
            }
            if (tuh >= closestTUH) continue;
            this.nextQueueWave = wave;
            closestTUH = tuh;
        }
    }

    public boolean isOpponentTooClose() {
        return this.opponentTooClose;
    }

    private void updateRollingHits(boolean hit) {
        if (this.rollingShots < this.rollingHitLog.length) {
            ++this.rollingShots;
            if (hit) {
                ++this.rollingHits;
            }
        } else if (this.rollingHitLog[this.rollingIndex] && !hit) {
            --this.rollingHits;
        } else if (!this.rollingHitLog[this.rollingIndex] && hit) {
            ++this.rollingHits;
        }
        this.rollingHitLog[this.rollingIndex] = hit;
        ++this.rollingIndex;
        if (this.rollingIndex >= this.rollingHitLog.length) {
            this.rollingIndex = 0;
        }
    }

    @Override
    public void onTurnEnd() {
        long time = Resources.getTime();
        Iterator<WavePair> iter = this.wavePairs.iterator();
        while (iter.hasNext()) {
            double oppDist;
            WavePair wavePair = iter.next();
            double myDist = wavePair.myShieldingWave.getBulletTravelDistance(time);
            if (!(myDist + (oppDist = wavePair.opponentWave.getBulletTravelDistance(time)) - RCPhysics.MAX_BULLET_VELOCITY * 1.5 > wavePair.distanceBetween)) continue;
            ++this.bulletShieldingShots;
            ++this.bulletShieldingConsecutiveMisses;
            this.updateRollingHits(false);
            this.missDamage += RCPhysics.getBulletDamage(wavePair.opponentWave.getBulletPower());
            iter.remove();
            this.fireShieldingShotMissed(wavePair);
        }
    }

    @Override
    public void oppWaveCreated(Wave wave) {
        this.opponentTooClose = false;
        if (Math.abs(wave.getInitialDefenderSnapshot().getVelocity()) < 0.01 && !wave.isEstimated()) {
            this.waveQueue.add(wave);
            this.justAddedToQueue = wave;
        }
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
        this.waveQueue.remove(wave);
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
        if (this.waveToShieldAgainst != null) {
            this.wavePairs.add(new WavePair(wave, this.waveToShieldAgainst));
            this.waveToShieldAgainst = null;
            this.bsDrive.requestMoveToStandingPosition();
        }
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
        Iterator<WavePair> iter = this.wavePairs.iterator();
        while (iter.hasNext()) {
            WavePair wavePair = iter.next();
            if (wavePair.myShieldingWave != wave) continue;
            iter.remove();
            ++this.bulletShieldingShots;
            ++this.bulletShieldingHits;
            this.updateRollingHits(true);
            this.bulletShieldingConsecutiveMisses = 0;
            this.fireShieldingShotHit(wavePair);
        }
    }

    private void fireShieldingShotHit(WavePair wavePair) {
        for (BulletShieldingListener listener : this.bulletShieldingListeners) {
            listener.shieldingShotHit(wavePair.myShieldingWave, wavePair.opponentWave);
        }
    }

    private void fireShieldingShotMissed(WavePair wavePair) {
        for (BulletShieldingListener listener : this.bulletShieldingListeners) {
            listener.shieldingShotMissed(wavePair.myShieldingWave, wavePair.opponentWave);
        }
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }

    @Override
    public String getPainterName() {
        return null;
    }

    private static class WavePair {
        private XBulletWave myShieldingWave;
        private Wave opponentWave;
        private double distanceBetween;

        public WavePair(XBulletWave myShieldingWave, Wave opponentWave) {
            this.myShieldingWave = myShieldingWave;
            this.opponentWave = opponentWave;
            this.distanceBetween = RCMath.getDistanceBetweenPoints(myShieldingWave.getOrigin(), opponentWave.getOrigin());
        }
    }
}

