/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import xander.core.drive.DirectDrivePredictor;
import xander.core.drive.DriveState;
import xander.core.math.RCMath;
import xander.core.track.Wave;
import xander.gfws.BasicFactorArrays;
import xander.gfws.RelativeAngleRange;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class DriveOptions
implements Paintable {
    public static final int IDX_DRIVE_HEADING = 0;
    public static final int IDX_FACTOR_ANGLE = 1;
    public static final int IDX_DRIVE_STATE_X = 2;
    public static final int IDX_DRIVE_STATE_Y = 3;
    private int dta;
    private double ti;
    private double[][] cwTestAngles;
    private double[][] ccwTestAngles;
    private int greatestCWIndex;
    private int greatestCCWIndex;
    private RelativeAngleRange mea;
    private DirectDrivePredictor predictor;
    private String painterName;

    public DriveOptions(int directionalTestAngles) {
        this.dta = directionalTestAngles;
        this.ti = 180.0 / (double)this.dta;
        this.cwTestAngles = new double[this.dta][4];
        this.ccwTestAngles = new double[this.dta][4];
    }

    public DriveOptions(String painterName, int directionalTestAngles) {
        this(directionalTestAngles);
        this.painterName = painterName;
        Paintables.addPaintable(this);
    }

    public DriveOptions(int directionalTestAngles, Rectangle2D.Double battlefieldBounds, Path2D.Double driveBounds) {
        this(directionalTestAngles);
        this.predictor = new DirectDrivePredictor(battlefieldBounds, driveBounds);
    }

    public DriveOptions(String painterName, int directionalTestAngles, Rectangle2D.Double battlefieldBounds, Path2D.Double driveBounds) {
        this(directionalTestAngles, battlefieldBounds, driveBounds);
        this.painterName = painterName;
        Paintables.addPaintable(this);
    }

    @Override
    public String getPainterName() {
        return this.painterName;
    }

    public void computeDriveOptions(Wave wave, DriveState defenderDriveState, long fromTime, DirectDrivePredictor predictor) {
        this.predictor = predictor;
        this.computeDriveOptions(wave, defenderDriveState, fromTime);
    }

    public void computeDriveOptions(Wave wave, DriveState defenderDriveState, long fromTime) {
        double inHeading = RCMath.getRobocodeAngle(defenderDriveState.getPosition(), wave.getOrigin());
        int i = 0;
        while (i < this.dta) {
            this.ccwTestAngles[i][0] = RCMath.normalizeDegrees(inHeading + ((double)i + 0.5) * this.ti);
            this.cwTestAngles[i][0] = RCMath.normalizeDegrees(inHeading + 180.0 + ((double)i + 0.5) * this.ti);
            ++i;
        }
        this.greatestCWIndex = -1;
        this.greatestCCWIndex = -1;
        i = 0;
        while (i < this.cwTestAngles.length) {
            DriveState testDriveState = this.predictor.predictDriveStateUntilWaveHits(wave, defenderDriveState, this.cwTestAngles[i][0], 8.0, fromTime);
            this.cwTestAngles[i][1] = BasicFactorArrays.getFactorAngle(wave, testDriveState.getPosition());
            this.cwTestAngles[i][2] = testDriveState.getX();
            this.cwTestAngles[i][3] = testDriveState.getY();
            if (this.greatestCWIndex == -1 || this.cwTestAngles[i][1] > this.cwTestAngles[this.greatestCWIndex][1]) {
                this.greatestCWIndex = i;
            }
            testDriveState = this.predictor.predictDriveStateUntilWaveHits(wave, defenderDriveState, this.ccwTestAngles[i][0], 8.0, fromTime);
            this.ccwTestAngles[i][1] = BasicFactorArrays.getFactorAngle(wave, testDriveState.getPosition());
            this.ccwTestAngles[i][2] = testDriveState.getX();
            this.ccwTestAngles[i][3] = testDriveState.getY();
            if (this.greatestCCWIndex == -1 || this.ccwTestAngles[i][1] < this.ccwTestAngles[this.greatestCCWIndex][1]) {
                this.greatestCCWIndex = i;
            }
            ++i;
        }
        this.mea = new RelativeAngleRange(this.ccwTestAngles[this.greatestCCWIndex][1], this.cwTestAngles[this.greatestCWIndex][1], "DriveOptions");
    }

    public double[][] getClockwiseTestAngleValues() {
        return this.cwTestAngles;
    }

    public double[][] getCounterClockwiseTestAngleValues() {
        return this.ccwTestAngles;
    }

    public double[] getClockwiseMEAValues() {
        return this.cwTestAngles[this.greatestCWIndex];
    }

    public double[] getCounterClockwiseMEAValues() {
        return this.ccwTestAngles[this.greatestCCWIndex];
    }

    public int getMEAClockwiseIndex() {
        return this.greatestCWIndex;
    }

    public int getMEACounterClockwiseIndex() {
        return this.greatestCCWIndex;
    }

    public RelativeAngleRange getMEA() {
        return this.mea;
    }

    public double getDriveHeading(boolean clockwise, int idx) {
        return clockwise ? this.cwTestAngles[idx][0] : this.ccwTestAngles[idx][0];
    }

    public double getFactorAngle(boolean clockwise, int idx) {
        return clockwise ? this.cwTestAngles[idx][1] : this.ccwTestAngles[idx][1];
    }

    public double getDriveStateX(boolean clockwise, int idx) {
        return clockwise ? this.cwTestAngles[idx][2] : this.ccwTestAngles[idx][2];
    }

    public double getDriveStateY(boolean clockwise, int idx) {
        return clockwise ? this.cwTestAngles[idx][3] : this.ccwTestAngles[idx][3];
    }
}

