/*
 * Decompiled with CFR 0.152.
 */
package xander.core.io;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BattleStats
implements Serializable {
    public static final String COMMON_STAT_KEY = "DfPEdfeWQzfcfckRlFDSo";
    private static final long serialVersionUID = 20110928L;
    private static final NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    String robotName;
    private boolean clearStatsOnNewVersion = true;
    Map<String, Map<String, String>> statMap = new HashMap<String, Map<String, String>>();

    public static void updateAveragedStatValue(Map<String, String> statMap, String key, double newValue, int decimalPlaces, int totalBattles) {
        String previousFormattedValue = statMap.get(key);
        if (previousFormattedValue != null) {
            double previousValue = newValue;
            try {
                previousValue = Double.parseDouble(previousFormattedValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newValue = (newValue + (double)(totalBattles - 1) * previousValue) / (double)totalBattles;
        }
        numberFormatter.setMinimumFractionDigits(decimalPlaces);
        numberFormatter.setMaximumFractionDigits(decimalPlaces);
        statMap.put(key, numberFormatter.format(newValue));
    }

    public static void updateAccumulator(Map<String, String> statMap, String key, int valueToAdd) {
        String previousFormattedValue = statMap.get(key);
        int value = 0;
        if (previousFormattedValue != null) {
            try {
                value = Integer.parseInt(previousFormattedValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        statMap.put(key, String.valueOf(value += valueToAdd));
    }

    public boolean isClearStatsOnNewVersion() {
        return this.clearStatsOnNewVersion;
    }

    public Set<String> getOpponentsInStats() {
        return this.statMap.keySet();
    }

    public void setClearStatsOnNewVersion(boolean clearStatsOnNewVersion) {
        this.clearStatsOnNewVersion = clearStatsOnNewVersion;
    }

    void clear() {
        this.statMap.clear();
    }

    public Map<String, String> getStatsForRobot(String robotName, boolean create) {
        Map<String, String> robotStats = this.statMap.get(robotName);
        if (robotStats == null && create) {
            robotStats = new HashMap<String, String>();
            this.statMap.put(robotName, robotStats);
        }
        return robotStats;
    }

    public Map<String, String> getCommonStats() {
        return this.getStatsForRobot(COMMON_STAT_KEY, true);
    }

    public String getStatForRobot(String robotName, String statName) {
        Map<String, String> robotStats = this.statMap.get(robotName);
        if (robotStats != null) {
            return robotStats.get(statName);
        }
        return null;
    }

    public void setStatForRobot(String robotName, String statName, String statValue) {
        Map<String, String> robotStats = this.statMap.get(robotName);
        if (robotStats == null) {
            robotStats = new HashMap<String, String>();
            this.statMap.put(robotName, robotStats);
        }
        robotStats.put(statName, statValue);
    }

    public void removeStatForRobot(String robotName, String statName) {
        Map<String, String> robotStats = this.statMap.get(robotName);
        if (robotStats != null) {
            robotStats.remove(statName);
            if (robotStats.size() == 0) {
                this.statMap.remove(robotName);
            }
        }
    }

    public void removeStatsForRobot(String robotName) {
        this.statMap.remove(robotName);
    }
}

