/*
 * Decompiled with CFR 0.152.
 */
package xander.core.log;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import xander.core.log.Log;

public class Logger {
    protected static Log.Level defaultLevel = Log.Level.INFO;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    protected static final Map<Class<?>, Log> logs = new HashMap();

    public static void setDefaultLogLevel(Log.Level level) {
        defaultLevel = level;
    }

    public static Log.Level getDefaultLogLevel() {
        return defaultLevel;
    }

    public static void setLogLevel(Class<?> c, Log.Level level) {
        Log log = logs.get(c);
        if (log != null) {
            log.setLevel(level);
        }
    }

    public static Log getLog(Class<?> c) {
        return Logger.getLog(c, null);
    }

    public static Log getLog(Class<?> c, Log.Level level) {
        Log log = logs.get(c);
        if (log == null) {
            log = new Log(c.getName(), level);
            logs.put(c, log);
        }
        return log;
    }

    public static String formatPosition(double x, double y) {
        return "(" + Logger.format(x) + "," + Logger.format(y) + ")";
    }

    public static String format(Point2D.Double p) {
        return "(" + Logger.format(p.x) + "," + Logger.format(p.y) + ")";
    }

    public static String format(double d, int minFractionDigits, int maxFractionDigits) {
        nf.setMaximumFractionDigits(maxFractionDigits);
        nf.setMinimumFractionDigits(minFractionDigits);
        return nf.format(d);
    }

    public static String format(double d, int maxFractionDigits) {
        nf.setMaximumFractionDigits(maxFractionDigits);
        return nf.format(d);
    }

    public static String format(double d) {
        return Logger.format(d, 1);
    }

    public static String format(int[] intArray) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < intArray.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(intArray[i]);
            ++i;
        }
        return "[" + sb.toString() + "]";
    }

    public static String format(double[] dArray, int maxFractionDigits) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < dArray.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Logger.format(dArray[i], maxFractionDigits));
            ++i;
        }
        return "[" + sb.toString() + "]";
    }

    public static String formatRobotState(AdvancedRobot robot) {
        StringBuilder sb = new StringBuilder();
        sb.append(";x=").append(Logger.format(robot.getX(), 3));
        sb.append(";y=").append(Logger.format(robot.getY(), 3));
        sb.append(";heading(radians)=").append(Logger.format(robot.getHeadingRadians(), 4));
        sb.append(";velocity=").append(Logger.format(robot.getVelocity(), 2));
        sb.append(";gunHeading(radians)=").append(Logger.format(robot.getGunHeadingRadians(), 4));
        sb.append(";energy=").append(Logger.format(robot.getEnergy(), 2));
        sb.append(";gunHeat=").append(Logger.format(robot.getGunHeat(), 2));
        return sb.toString();
    }
}

