/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import robocode.BattleEndedEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RoundEndedEvent;
import xander.core.Component;
import xander.core.ComponentChain;
import xander.core.Configuration;
import xander.core.RegisteredComponentListener;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.drive.Drive;
import xander.core.event.CollisionListener;
import xander.core.event.RoundListener;
import xander.core.event.TurnListener;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;

public class DriveStats
implements TurnListener,
RoundListener,
CollisionListener,
RegisteredComponentListener {
    private static final String NO_DRIVE = "No Drive";
    private static final Log log = Logger.getLog(DriveStats.class);
    private RobotProxy robotProxy;
    private Map<String, Long> driveTimes = new HashMap<String, Long>();
    private String activeDrive = "No Drive";
    private long activeDriveStartTime = 0L;
    private boolean logDriveTimes;
    private int wallHits;
    private int robotHits;
    private double wallHitDmgAccum;

    public DriveStats(RobotProxy robotProxy, RobotEvents robotEvents, Configuration configuration, ComponentChain chain) {
        this.robotProxy = robotProxy;
        this.logDriveTimes = configuration.isLogDriveTimes();
        robotEvents.addTurnListener(this);
        robotEvents.addRoundListener(this);
        robotEvents.addCollisionListener(this);
        chain.addRegisteredComponentListener(this);
    }

    @Override
    public void componentRegistered(Component component) {
        if (component instanceof Drive) {
            this.driveTimes.put(component.getName(), 0L);
        }
    }

    @Override
    public void onTurnBegin() {
    }

    @Override
    public void onTurnEnd() {
        String currentActiveDrive = this.robotProxy.getActiveDriveName();
        if (currentActiveDrive == null) {
            currentActiveDrive = NO_DRIVE;
        }
        if (!currentActiveDrive.equals(this.activeDrive)) {
            long cumulativeTime = Resources.getCumulativeTime();
            long timeForActiveDrive = cumulativeTime - this.activeDriveStartTime;
            if (timeForActiveDrive > 0L) {
                Long prevTime = this.driveTimes.get(this.activeDrive);
                if (prevTime == null) {
                    this.driveTimes.put(this.activeDrive, timeForActiveDrive);
                } else {
                    this.driveTimes.put(this.activeDrive, timeForActiveDrive + prevTime);
                }
            }
            this.activeDrive = currentActiveDrive;
            this.activeDriveStartTime = cumulativeTime;
        }
    }

    public long getDriveTime(String driveName) {
        Long driveTime = this.driveTimes.get(driveName);
        if (driveTime == null) {
            return 0L;
        }
        return driveTime;
    }

    public int getWallHits() {
        return this.wallHits;
    }

    public double getAverageWallHitDamage() {
        return this.wallHits > 0 ? this.wallHitDmgAccum / (double)this.wallHits : 0.0;
    }

    public int getRobotHits() {
        return this.robotHits;
    }

    public Set<String> getDriveNames() {
        return this.driveTimes.keySet();
    }

    public double getDriveUsagePercent(String driveName) {
        long driveTime = this.getDriveTime(driveName);
        return (double)driveTime / (double)Resources.getCumulativeTime();
    }

    private void logDriveTimes() {
        for (Map.Entry<String, Long> entry : this.driveTimes.entrySet()) {
            log.stat(String.valueOf(entry.getKey()) + ": " + entry.getValue().toString() + " ticks");
        }
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
        if (this.logDriveTimes) {
            this.logDriveTimes();
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        ++this.robotHits;
    }

    @Override
    public void onHitWall(HitWallEvent event) {
        ++this.wallHits;
        Snapshot snap = Resources.getSnapshotHistory().getMySnapshot(event.getTime() - 1L, true);
        this.wallHitDmgAccum += RCPhysics.getWallHitDamage(snap.getVelocity());
    }
}

