/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import xander.core.drive.Direction;
import xander.gfws.FactorIndexer;
import xander.gfws.IndexRange;
import xander.gfws.RelativeAngleRange;

public class BalancedFactorIndexer
implements FactorIndexer {
    @Override
    public double getPreciseFactorIndex(double factorAngle, int factors, Direction surfDirection, RelativeAngleRange mea) {
        if (surfDirection.isClockwise()) {
            double m = (double)factors / (mea.getClockwiseOffset() - mea.getCounterClockwiseOffset());
            double b = -m * mea.getCounterClockwiseOffset();
            return m * factorAngle + b;
        }
        double m = (double)factors / (mea.getCounterClockwiseOffset() - mea.getClockwiseOffset());
        double b = -m * mea.getClockwiseOffset();
        return m * factorAngle + b;
    }

    @Override
    public int getFactorIndex(double factorAngle, int factors, Direction surfDirection, RelativeAngleRange mea) {
        return (int)Math.round(Math.floor(this.getPreciseFactorIndex(factorAngle, factors, surfDirection, mea)));
    }

    @Override
    public double getFactorAngle(double preciseFactorIndex, int factors, Direction surfDirection, RelativeAngleRange mea) {
        if (surfDirection.isClockwise()) {
            double m = (mea.getClockwiseOffset() - mea.getCounterClockwiseOffset()) / (double)factors;
            return m * preciseFactorIndex + mea.getCounterClockwiseOffset();
        }
        double m = (mea.getCounterClockwiseOffset() - mea.getClockwiseOffset()) / (double)factors;
        return m * preciseFactorIndex + mea.getClockwiseOffset();
    }

    @Override
    public IndexRange getRobotIndexWidth(int factors, double distance, double currentRobotFactorAngle, Direction surfDirection, RelativeAngleRange mea) {
        double cwIdx;
        double circ = Math.PI * 2 * distance;
        double halfBodyWidthDegrees = 7200.0 / circ;
        double ccwIdx = this.getPreciseFactorIndex(currentRobotFactorAngle - halfBodyWidthDegrees, factors, surfDirection, mea);
        if (ccwIdx < (cwIdx = this.getPreciseFactorIndex(currentRobotFactorAngle + halfBodyWidthDegrees, factors, surfDirection, mea))) {
            return new IndexRange(ccwIdx, cwIdx);
        }
        return new IndexRange(cwIdx, ccwIdx);
    }
}

