/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import java.awt.geom.Point2D;
import java.util.List;
import xander.gfws.RelativeAngleRange;

public class FactorRange {
    int beginIndex;
    int endIndex;
    int currentDefenderIndex;
    int maxClockwiseIndex;
    int maxCounterClockwiseIndex;
    RelativeAngleRange mea;
    List<Point2D.Double> clockwisePath;
    double[] clockwiseDistances;
    double[] clockwiseFactorIndexes;
    List<Point2D.Double> counterClockwisePath;
    double[] counterClockwiseDistances;
    double[] counterClockwiseFactorIndexes;
    boolean diveProtected;

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getCurrentDefenderIndex() {
        return this.currentDefenderIndex;
    }

    public int getMaxClockwiseIndex() {
        return this.maxClockwiseIndex;
    }

    public int getMaxCounterClockwiseIndex() {
        return this.maxCounterClockwiseIndex;
    }

    public List<Point2D.Double> getClockwisePath() {
        return this.clockwisePath;
    }

    public double[] getClockwiseDistances() {
        return this.clockwiseDistances;
    }

    public double[] getClockwiseFactorIndexes() {
        return this.clockwiseFactorIndexes;
    }

    public List<Point2D.Double> getCounterClockwisePath() {
        return this.counterClockwisePath;
    }

    public double[] getCounterClockwiseDistances() {
        return this.counterClockwiseDistances;
    }

    public double[] getCounterClockwiseFactorIndexes() {
        return this.counterClockwiseFactorIndexes;
    }

    public RelativeAngleRange getMaxFactorAngles() {
        return this.mea;
    }

    public double getMaxClockwiseFactorAngle() {
        return this.mea == null ? 0.0 : this.mea.getClockwiseOffset();
    }

    public double getMaxCounterClockwiseFactorAngle() {
        return this.mea == null ? 0.0 : this.mea.getCounterClockwiseOffset();
    }

    public boolean isDiveProtected() {
        return this.diveProtected;
    }

    public double getDistanceForPreciseFactorIndex(double preciseIndex) {
        double offset;
        double closestIndexOffset = Double.POSITIVE_INFINITY;
        double distance = -1.0;
        int i = 0;
        while (i < this.counterClockwiseFactorIndexes.length) {
            offset = Math.abs(preciseIndex - this.counterClockwiseFactorIndexes[i]);
            if (offset < closestIndexOffset) {
                closestIndexOffset = offset;
                distance = this.counterClockwiseDistances[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.clockwiseFactorIndexes.length) {
            offset = Math.abs(preciseIndex - this.clockwiseFactorIndexes[i]);
            if (offset < closestIndexOffset) {
                closestIndexOffset = offset;
                distance = this.clockwiseDistances[i];
            }
            ++i;
        }
        return distance;
    }
}

