/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import xander.core.Resources;
import xander.core.math.RCMath;
import xander.core.track.BulletShadow;
import xander.core.track.Wave;
import xander.gfws.BasicFactorArrays;
import xander.gfws.FactorIndexer;
import xander.gfws.data.CachingFactorArrayProcessor;
import xander.gfws.data.DataPoint;
import xander.gfws.data.FactorArrayParms;
import xander.gfws.data.LogReader;
import xander.gfws.data.WaveSearchIterable;
import xander.gfws.data.WaveSearchIterator;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class DataPointFactorArrayProcessor
extends CachingFactorArrayProcessor
implements Paintable {
    private String painterName;
    private int factors;
    private FactorArrayParms parms;
    private LogReader logReader;
    private int flattenerOn;
    private int flattenerOff;
    private double myHitRatio;
    private double oppHitRatio;
    private FactorIndexer factorIndexer;

    public DataPointFactorArrayProcessor(LogReader logReader, int factors, FactorArrayParms parms) {
        this(null, logReader, factors, parms);
    }

    public DataPointFactorArrayProcessor(String painterName, LogReader logReader, int factors, FactorArrayParms parms) {
        super(factors);
        this.painterName = painterName;
        this.logReader = logReader;
        this.factors = factors;
        this.parms = parms;
        this.factorIndexer = parms.isOffensive() ? Resources.getOpponentFactorIndexer() : Resources.getMyFactorIndexer();
        Paintables.addPaintable(this);
    }

    @Override
    public String getPainterName() {
        return this.painterName;
    }

    public double getFlattenerUsePercentage() {
        int totalCount = this.flattenerOn + this.flattenerOff;
        return totalCount == 0 ? 0.0 : (double)this.flattenerOn / (double)totalCount;
    }

    private void addFactorArrayPoint(double[] factorArray, FactorArrayParms parms, double cweight, DataPoint dataPoint, long referenceTime) {
        if (parms.varyWeightByAge) {
            long age = referenceTime - dataPoint.logTime;
            cweight *= Math.max(parms.minAgeWeightPercent, parms.varyWeightByAgeFunction.getMultiplier(age));
        }
        if (parms.varyWeightByDistance) {
            cweight *= dataPoint.distance / 400.0;
        }
        if (parms.varyWeightByMEA) {
            cweight *= RCMath.getMEASignificance(dataPoint.mea, dataPoint.distance);
        }
        double preciseFactorIndex = dataPoint.getFactorIndex(this.factors);
        parms.distributer.addWeight(factorArray, preciseFactorIndex, cweight, dataPoint.distance, dataPoint.bulletVelocity, dataPoint.surfDirection);
    }

    @Override
    public void fillFactorArray(double[] factorArray, Wave surfWave, double currentMinFactorAngle, double currentMaxFactorAngle) {
        boolean useFlattenerThisWave;
        long cumulativeTime = Resources.getCumulativeTime();
        WaveSearchIterable<DataPoint> knnHitData = this.logReader.getHitData(surfWave);
        int counter = 0;
        this.oppHitRatio = Resources.getGunStats().getOverallOpponentHitRatio();
        this.myHitRatio = Resources.getGunStats().getOverallHitRatio();
        boolean bl = useFlattenerThisWave = this.parms.useFlattener && this.oppHitRatio > this.parms.useFlattenerOnHitPercentage && this.myHitRatio < this.oppHitRatio && Resources.getRobotProxy().getRoundNum() >= this.parms.useFlattenerEarliestRound;
        if (useFlattenerThisWave) {
            ++this.parms.flattenerOnCount;
            ++this.flattenerOn;
        } else {
            ++this.parms.flattenerOffCount;
            ++this.flattenerOff;
        }
        long referenceTime = 0L;
        WaveSearchIterator<DataPoint> iter = knnHitData.iterator();
        while (iter.hasNext()) {
            DataPoint dataPoint = (DataPoint)iter.next();
            referenceTime = Math.max(referenceTime, dataPoint.logTime);
        }
        double maxDistance = knnHitData.getMaxDistance();
        if (this.parms.varyWeightBySearchDistanceMinMaxDistance != null) {
            maxDistance = Math.max(maxDistance, this.parms.varyWeightBySearchDistanceMinMaxDistance);
        }
        double maxDrop = 1.0 - this.parms.varyWeightBySearchDistanceMinimum;
        WaveSearchIterator<DataPoint> iter2 = knnHitData.iterator();
        while (iter2.hasNext()) {
            DataPoint dataPoint = (DataPoint)iter2.next();
            double weight = this.parms.weight;
            if (this.parms.varyWeightBySearchDistance) {
                weight *= 1.0 - maxDrop * (iter2.getSearchDistance() / maxDistance);
            }
            this.addFactorArrayPoint(factorArray, this.parms, weight, dataPoint, referenceTime);
            ++counter;
        }
        if (useFlattenerThisWave) {
            double cweight = this.parms.weight * this.parms.useFlattenerVisitPercentage;
            WaveSearchIterable<DataPoint> knnVisitData = this.logReader.getVisitData(surfWave);
            WaveSearchIterator<DataPoint> iter3 = knnVisitData.iterator();
            while (iter3.hasNext()) {
                DataPoint visitDataPoint = (DataPoint)iter3.next();
                this.addFactorArrayPoint(factorArray, this.parms, cweight, visitDataPoint, cumulativeTime);
            }
        }
        if (counter <= this.parms.maxDataPointsForUsingArrayInitializer) {
            this.parms.arrayInitializer.modify(factorArray, surfWave);
            ++counter;
        }
        if (this.parms.useBulletShadows) {
            for (BulletShadow shadow : surfWave.getBulletShadows()) {
                double ccwShadowFactorAngle = BasicFactorArrays.getFactorAngle(surfWave, shadow.getCounterClockwiseAngle());
                double cwShadowFactorAngle = BasicFactorArrays.getFactorAngle(surfWave, shadow.getClockwiseAngle());
                double ccwShadowIndex = 0.0;
                double cwShadowIndex = 0.0;
                ccwShadowIndex = this.factorIndexer.getPreciseFactorIndex(ccwShadowFactorAngle, factorArray.length, surfWave.getSurfDirection(), surfWave.getInitialMEA());
                cwShadowIndex = this.factorIndexer.getPreciseFactorIndex(cwShadowFactorAngle, factorArray.length, surfWave.getSurfDirection(), surfWave.getInitialMEA());
                double pBeginIndex = cwShadowIndex > ccwShadowIndex ? ccwShadowIndex : cwShadowIndex;
                double pEndIndex = cwShadowIndex > ccwShadowIndex ? cwShadowIndex : ccwShadowIndex;
                int beginIndex = (int)Math.round(Math.ceil(pBeginIndex));
                int endIndex = (int)Math.round(Math.floor(pEndIndex));
                int i = beginIndex;
                while (i < endIndex) {
                    if (i >= 0 && i < factorArray.length) {
                        factorArray[i] = 0.0;
                    }
                    ++i;
                }
                if (beginIndex - 1 >= 0 && beginIndex - 1 < factorArray.length) {
                    double f = 1.0 - ((double)beginIndex - pBeginIndex);
                    int n = beginIndex - 1;
                    factorArray[n] = factorArray[n] * f;
                }
                if (endIndex < 0 || endIndex >= factorArray.length) continue;
                double f = 1.0 - (pEndIndex - (double)endIndex);
                int n = endIndex;
                factorArray[n] = factorArray[n] * f;
            }
        }
    }
}

