/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import java.util.Arrays;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.track.Wave;
import xander.gfws.data.AbstractWaveLogger;
import xander.gfws.data.DataPoint;
import xander.gfws.data.EmptyWaveSearchIterable;
import xander.gfws.data.KDTreeAdapter;
import xander.gfws.data.KNNParms;
import xander.gfws.data.WaveSearchIterable;
import xander.gfws.segment.Segmenter;

public abstract class KDTreeWaveLogger
extends AbstractWaveLogger<KNNParms> {
    private static final Log log = Logger.getLog(KDTreeWaveLogger.class);
    private KDTreeAdapter<DataPoint> hitTree;
    private KDTreeAdapter<DataPoint> visitTree;
    private double[] lowRange;
    private double[] highRange;
    private double[] segmentWeights;

    public KDTreeWaveLogger(boolean offensive, Segmenter ... segmenters) {
        this(offensive, Integer.MAX_VALUE, Integer.MAX_VALUE, segmenters);
    }

    public KDTreeWaveLogger(boolean offensive, int maxHits, int maxVisits, Segmenter ... segmenters) {
        super(offensive, segmenters);
        this.hitTree = this.createHitTreeAdapter(segmenters.length, maxHits);
        this.visitTree = this.createVisitTreeAdapter(segmenters.length, maxVisits);
        this.lowRange = new double[segmenters.length];
        this.highRange = new double[segmenters.length];
        this.segmentWeights = new double[segmenters.length];
        Arrays.fill(this.segmentWeights, 1.0);
    }

    protected abstract KDTreeAdapter<DataPoint> createHitTreeAdapter(int var1, int var2);

    protected abstract KDTreeAdapter<DataPoint> createVisitTreeAdapter(int var1, int var2);

    public void setSegmentWeight(int segmentIndex, double weight) {
        this.segmentWeights[segmentIndex] = weight;
    }

    private double[] createKey(Wave wave, Segmenter[] segmenters) {
        double[] key = new double[segmenters.length];
        int i = 0;
        while (i < segmenters.length) {
            key[i] = segmenters[i].getSegmentValuePercent(wave) * this.segmentWeights[i];
            ++i;
        }
        return key;
    }

    private void setRanges(double[] key, double[] rangeSpan) {
        int i = 0;
        while (i < rangeSpan.length) {
            double halfSpan = rangeSpan[i] / 2.0;
            this.lowRange[i] = key[i] - halfSpan;
            this.highRange[i] = key[i] + halfSpan;
            ++i;
        }
    }

    @Override
    public WaveSearchIterable<DataPoint> getHitData(Wave wave, Segmenter[] segmenters, KNNParms parms) {
        double[] key = this.createKey(wave, segmenters);
        WaveSearchIterable<DataPoint> searchResult = null;
        try {
            if (parms.isSelectByKNN()) {
                int n = Math.min(this.hitTree.size(), parms.getK(this.totalHits));
                if (n > 0) {
                    searchResult = this.hitTree.searchByKNN(key, n);
                }
            } else if (parms.isSelectByHitsWithinKNNVisits()) {
                if (this.hitTree.size() > 0) {
                    searchResult = this.hitTree.searchByDistance(key, parms.visitDistance);
                    log.debug(String.valueOf(searchResult.size()) + " hits pulled.");
                }
            } else {
                this.setRanges(key, parms.getRangeSpan());
                searchResult = this.hitTree.searchByRange(this.lowRange, this.highRange);
                log.debug(String.valueOf(searchResult.size()) + " hits pulled.");
            }
            if ((searchResult == null || searchResult.size() == 0) && this.hitTree.size() > 0 && parms.getKnnWhenSelectionEmpty() > 0) {
                searchResult = this.hitTree.searchByKNN(key, parms.getKnnWhenSelectionEmpty());
            }
        }
        catch (Exception e) {
            log.error("Error on getData: " + e.getMessage());
        }
        return searchResult == null ? new EmptyWaveSearchIterable() : searchResult;
    }

    @Override
    protected WaveSearchIterable<DataPoint> getVisitData(Wave wave, Segmenter[] segmenters, KNNParms parms) {
        double[] key = this.createKey(wave, segmenters);
        WaveSearchIterable<Object> searchResult = null;
        try {
            if (parms.isSelectByKNN()) {
                int n = Math.min(this.visitTree.size(), parms.getVisitKAsPercentOfHitK(this.totalHits));
                if (n > 0) {
                    searchResult = this.visitTree.searchByKNN(key, n);
                }
            } else if (parms.isSelectByHitsWithinKNNVisits()) {
                int n = Math.min(this.visitTree.size(), parms.getK(this.totalVisits));
                if (n > 0) {
                    searchResult = this.visitTree.searchByKNN(key, n);
                    log.debug(String.valueOf(searchResult.size()) + " visits pulled.");
                }
            } else {
                this.setRanges(key, parms.getRangeSpan());
                searchResult = this.hitTree.searchByRange(this.lowRange, this.highRange);
            }
            if ((searchResult == null || searchResult.size() == 0) && this.visitTree.size() > 0 && parms.getKnnWhenSelectionEmpty() > 0) {
                searchResult = this.visitTree.searchByKNN(key, parms.getKnnWhenSelectionEmpty());
            }
        }
        catch (Exception e) {
            log.error("Error on getData: " + e.getMessage());
        }
        return searchResult == null ? new EmptyWaveSearchIterable() : searchResult;
    }

    @Override
    protected void addHit(Wave bulletWave, Segmenter[] segmenters, DataPoint dataPoint) {
        double[] key = this.createKey(bulletWave, segmenters);
        this.hitTree.addPoint(key, dataPoint);
    }

    @Override
    protected void addVisit(Wave bulletWave, Segmenter[] segmenters, DataPoint dataPoint) {
        double[] key = this.createKey(bulletWave, segmenters);
        this.visitTree.addPoint(key, dataPoint);
    }
}

