/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.bot;

import eem.frame.core.CoreBot;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class botStatPoint {
    private Point2D.Double pos = new Point2D.Double(0.0, 0.0);
    private long tStamp = 0L;
    private double headingDegrees = 0.0;
    private double speed = 0.0;
    private double energy = 0.0;
    private double gunHeat = 0.0;
    private double dist2WallAhead = 0.0;

    public botStatPoint() {
    }

    public botStatPoint(AdvancedRobot advancedRobot, ScannedRobotEvent scannedRobotEvent) {
        this();
        Point2D.Double double_ = new Point2D.Double();
        double_.x = advancedRobot.getX();
        double_.y = advancedRobot.getY();
        double d = Math.toRadians(advancedRobot.getHeading() + scannedRobotEvent.getBearing());
        double d2 = scannedRobotEvent.getDistance();
        this.pos = new Point2D.Double(double_.x + Math.sin(d) * d2, double_.y + Math.cos(d) * d2);
        this.tStamp = advancedRobot.getTime();
        this.headingDegrees = scannedRobotEvent.getHeading();
        this.speed = scannedRobotEvent.getVelocity();
        this.energy = scannedRobotEvent.getEnergy();
    }

    public botStatPoint(CoreBot coreBot) {
        this();
        this.pos.x = coreBot.getX();
        this.pos.y = coreBot.getY();
        this.tStamp = coreBot.getTime();
        this.headingDegrees = coreBot.getHeading();
        this.speed = coreBot.getVelocity();
        this.energy = coreBot.getEnergy();
        this.dist2WallAhead = this.distanceToWallAhead();
    }

    public botStatPoint(Point2D.Double double_, long l) {
        this();
        this.tStamp = l;
        this.pos = double_;
    }

    public Double getDistanceToWallAhead() {
        return this.dist2WallAhead;
    }

    public Double getDistance(Point2D.Double double_) {
        return double_.distance(this.pos);
    }

    public String format() {
        String string = "";
        string = string + "tStamp = " + this.tStamp;
        string = string + ", ";
        string = string + "position = [" + logger.shortFormatDouble(this.pos.x) + ", " + logger.shortFormatDouble(this.pos.y) + "]";
        string = string + ", ";
        string = string + "energy = " + logger.shortFormatDouble(this.energy);
        string = string + ", ";
        string = string + "speed = " + logger.shortFormatDouble(this.speed);
        string = string + ", ";
        string = string + "heading = " + logger.shortFormatDouble(this.headingDegrees);
        string = string + ", ";
        string = string + "distance to " + this.whichWallAhead() + " wall ahead = " + logger.shortFormatDouble(this.getDistanceToWallAhead());
        return string;
    }

    public long getTime() {
        return this.tStamp;
    }

    public void setTime(long l) {
        this.tStamp = l;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getHeadingDegrees() {
        return this.headingDegrees;
    }

    public void setHeadingDegrees(double d) {
        this.headingDegrees = d;
    }

    public double getHeadingRadians() {
        return Math.toRadians(this.headingDegrees);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public Point2D.Double getVelocity() {
        Point2D.Double double_ = new Point2D.Double(this.speed * Math.sin(Math.toRadians(this.headingDegrees)), this.speed * Math.cos(Math.toRadians(this.headingDegrees)));
        return double_;
    }

    public double getLateralSpeed(Point2D.Double double_) {
        double d = math.angle2pt(double_, this.pos);
        double d2 = this.speed * Math.sin(Math.toRadians(this.headingDegrees - d));
        return d2;
    }

    public Point2D.Double getPosition() {
        return (Point2D.Double)this.pos.clone();
    }

    public void setPosition(Point2D.Double double_) {
        this.pos = (Point2D.Double)double_.clone();
    }

    public Double getGunHeat() {
        return this.gunHeat;
    }

    public boolean arePointsOfPathSimilar(botStatPoint botStatPoint2, botStatPoint botStatPoint3, botStatPoint botStatPoint4) {
        double d = 80.0;
        double d2 = 4.0;
        double d3 = 0.2;
        double d4 = 0.5;
        double d5 = 50.0;
        double d6 = 2.0;
        double d7 = 10.0;
        double d8 = this.getSpeed();
        double d9 = this.getHeadingDegrees() - botStatPoint4.getHeadingDegrees();
        long l = this.getTime() - botStatPoint4.getTime();
        double d10 = this.getDistanceToWallAhead();
        double d11 = botStatPoint3.getSpeed();
        double d12 = botStatPoint3.getHeadingDegrees() - botStatPoint2.getHeadingDegrees();
        long l2 = botStatPoint3.getTime() - botStatPoint2.getTime();
        double d13 = botStatPoint3.getDistanceToWallAhead();
        boolean bl = true;
        if (Math.abs(d8 - d11) > d4 || Math.abs(math.shortest_arc(d9 - d12)) > d7) {
            bl = false;
        } else if (l != l2) {
            bl = false;
        } else if (Math.min(d13, d10) < d && Math.abs(d10 - d13) > d2) {
            bl = false;
        }
        return bl;
    }

    public String whichWallAhead(botStatPoint botStatPoint2) {
        return physics.whichWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public String whichWallAhead() {
        return this.whichWallAhead(this);
    }

    public double distanceToWallAhead(botStatPoint botStatPoint2) {
        return physics.distanceToWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public double distanceToWallAhead() {
        return this.distanceToWallAhead(this);
    }
}

