/*
 * Decompiled with CFR 0.152.
 */
package tango;

import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Recrimpo
extends AdvancedRobot {
    static boolean flatten = false;
    static int hit = 0;
    static int[][] GuessFactors = new int[51][5];
    static boolean loaded = false;
    static String enemyName;
    double lastHeading;
    double lastTime;
    double lastReverse;
    Point2D EnemyLocation;
    int hisDir;
    int hisOldDir;
    int anti;
    int max;
    int min;
    Vector Waves;
    Point2D EnemyCurrent;
    Point2D PostdictedEnemyFuture;
    Point2D CurrentLocation;
    Wave CurrentWave;
    int i;
    int j;
    int k;
    int l;
    int GuessFactor;
    int dir;
    double PostdictedMoveDistance;
    double a;
    double b;
    double c;
    double AngleOffset;
    double lastBearing;
    double angleToTurn;
    double velocity;
    double lastVelocity;
    boolean clockwise;

    public void run() {
        this.out.println(this.getRoundNum());
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAhead(Double.POSITIVE_INFINITY);
        this.setTurnRadarRight(360.0);
        while (true) {
            double radarAngle = Utils.normalRelativeAngle((double)(this.absoluteBearing(new Point2D.Double(this.getX(), this.getY()), this.EnemyLocation) - this.getRadarHeadingRadians()));
            if ((double)this.getTime() - this.lastTime < (double)3) {
                this.setTurnRadarRightRadians(radarAngle + (double)(radarAngle > 0.0 ? 22 : -22));
            } else {
                this.setTurnRadarRight(360.0);
            }
            double heading = Math.toDegrees(Utils.normalAbsoluteAngle((double)Math.toRadians(this.getHeading() - (double)(this.dir == -1 ? 180 : 0))));
            double desiredHeading = Math.toDegrees(Utils.normalAbsoluteAngle((double)Math.toRadians(Math.toDegrees(this.absoluteBearing(new Point2D.Double(this.getX(), this.getY()), this.EnemyLocation)) - 90.0 - (double)(this.dir == -1 ? 180 : 0))));
            if (heading > 0.0 && heading < 180.0 && this.getBattleFieldWidth() - this.getX() < 100.0) {
                this.max = 180;
                this.min = 0;
                if (desiredHeading > 90.0) {
                    this.setTurnRightRadians(Utils.normalRelativeAngle((double)Math.toRadians(180.0 - heading)));
                } else {
                    this.setTurnLeftRadians(Utils.normalRelativeAngle((double)Math.toRadians(heading)));
                }
            } else if (heading > 180.0 && heading < 360.0 && this.getX() < 100.0) {
                this.max = 360;
                this.min = 180;
                if (desiredHeading > 270.0) {
                    this.setTurnRightRadians(Utils.normalRelativeAngle((double)Math.toRadians(360.0 - heading)));
                } else {
                    this.setTurnLeftRadians(Utils.normalRelativeAngle((double)Math.toRadians(heading - 180.0)));
                }
            } else if (heading > 90.0 && heading < 270.0 && this.getY() < 100.0) {
                this.max = 270;
                this.min = 90;
                if (desiredHeading > 180.0) {
                    this.setTurnRightRadians(Utils.normalRelativeAngle((double)Math.toRadians(270.0 - heading)));
                } else {
                    this.setTurnLeftRadians(Utils.normalRelativeAngle((double)Math.toRadians(heading - 90.0)));
                }
            } else {
                if ((heading > 270.0 || heading < 90.0) && this.getBattleFieldHeight() - this.getY() < 100.0) {
                    this.max = 90;
                    this.min = 270;
                    if (desiredHeading > 0.0) {
                        this.setTurnRightRadians(Utils.normalRelativeAngle((double)Math.toRadians(90.0 - heading)));
                    } else {
                        this.setTurnLeftRadians(Utils.normalRelativeAngle((double)Math.toRadians(heading - 270.0)));
                    }
                } else {
                    this.max = 1000;
                    this.min = -1000;
                }
                if (Math.random() < 0.05 && flatten) {
                    this.reverse();
                }
            }
            int BestGuess = 25;
            int DistanceIndex = 0;
            this.CurrentLocation = new Point2D.Double(this.getX(), this.getY());
            if (this.EnemyCurrent != null) {
                double Distance = this.CurrentLocation.distance(this.EnemyCurrent);
                if (Distance < 101.0) {
                    DistanceIndex = 0;
                } else if (Distance > 100.0 && Distance < 301.0) {
                    DistanceIndex = 1;
                } else if (Distance > 300.0 && Distance < 501.0) {
                    DistanceIndex = 2;
                } else if (Distance > 500.0 && Distance < 701.0) {
                    DistanceIndex = 3;
                } else if (Distance > 700.0) {
                    DistanceIndex = 4;
                }
                this.i = 0;
                while (this.i < 51) {
                    if (GuessFactors[this.i][DistanceIndex] > GuessFactors[BestGuess][DistanceIndex]) {
                        BestGuess = this.i;
                    }
                    ++this.i;
                }
                double power = 3;
                double offset = ((double)BestGuess - 25.0) / 25.0 * Math.asin(8.0 / (20.0 - (double)3 * power)) * (double)(this.clockwise ? 1 : -1);
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.lastBearing - this.getGunHeadingRadians() + offset)));
                if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < (double)5) {
                    this.setFire(power);
                    this.Waves.addElement(new Wave(this.getTime(), this.CurrentLocation, power, this.CurrentLocation.distance(this.EnemyCurrent), this.lastBearing, this.lastVelocity, this.EnemyCurrent, this.clockwise));
                }
            }
            this.execute();
        }
    }

    private final double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absbearing = (this.getHeading() + e.getBearing()) % 360.0;
        double x = this.getX() + Math.sin(Math.toRadians(absbearing)) * e.getDistance();
        double y = this.getY() + Math.cos(Math.toRadians(absbearing)) * e.getDistance();
        this.EnemyLocation.setLocation(x, y);
        this.lastTime = this.getTime();
        this.GFScan(e);
        this.MoveScan(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if ((double)this.getTime() - this.lastReverse > this.EnemyLocation.distance(this.getX(), this.getY()) / (20.0 - (double)3 * e.getPower())) {
            flatten = true;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.reverse();
    }

    public void onDeath(DeathEvent e) {
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            this.saveFactors(enemyName, GuessFactors);
        }
    }

    public void onWin(WinEvent e) {
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            this.saveFactors(enemyName, GuessFactors);
        }
    }

    public void GFScan(ScannedRobotEvent e) {
        if (!loaded) {
            GuessFactors = this.restoreFactors(e.getName());
            this.i = 0;
            while (this.i < 51) {
                this.out.println("Starting VC for GF " + this.i + " was " + GuessFactors[this.i][0] + ',' + GuessFactors[this.i][1] + ',' + GuessFactors[this.i][2] + ',' + GuessFactors[this.i][3] + ',' + GuessFactors[this.i][4]);
                ++this.i;
            }
        }
        loaded = true;
        enemyName = e.getName();
        int DistanceIndex = 0;
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
        this.angleToTurn = 90.0 - e.getBearing();
        if (e.getDistance() < 150.0) {
            this.angleToTurn += 20.0;
        }
        if (e.getDistance() > 500.0) {
            this.angleToTurn -= 20.0;
        }
        this.angleToTurn = Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(this.angleToTurn)));
        this.clockwise = Utils.normalAbsoluteAngle((double)Math.toRadians(e.getBearing() + this.getHeading())) - this.lastBearing >= 0.0;
        this.EnemyCurrent = new Point2D.Double(this.getX() + Math.sin(e.getBearingRadians() + this.getHeadingRadians()) * e.getDistance(), this.getY() + Math.cos(e.getBearingRadians() + this.getHeadingRadians()) * e.getDistance());
        this.CurrentLocation = new Point2D.Double(this.getX(), this.getY());
        if (this.Waves.size() > 0) {
            this.i = 0;
            while (this.i < this.Waves.size()) {
                this.CurrentWave = (Wave)this.Waves.elementAt(this.i);
                if (this.CurrentWave.Hit(this.EnemyCurrent, this.i)) {
                    double EnemyNewBearing = Utils.normalAbsoluteAngle((double)Math.atan2(this.EnemyCurrent.getX() - this.CurrentWave.FiredPosition.getX(), this.EnemyCurrent.getY() - this.CurrentWave.FiredPosition.getY()));
                    this.AngleOffset = Utils.normalRelativeAngle((double)(EnemyNewBearing - this.CurrentWave.EnemyOriginalBearing)) * (double)(this.CurrentWave.clockwise ? 1 : -1);
                    this.GuessFactor = (int)Math.round(this.AngleOffset / Math.asin(8.0 / (20.0 - this.CurrentWave.Power * (double)3)) * 25.0) + 25;
                    if (this.GuessFactor < 0) {
                        this.GuessFactor = 0;
                    }
                    if (this.GuessFactor > 50) {
                        this.GuessFactor = 50;
                    }
                    if (this.CurrentWave.EnemyOriginalDistance < 101.0) {
                        DistanceIndex = 0;
                    } else if (this.CurrentWave.EnemyOriginalDistance > 100.0 && this.CurrentWave.EnemyOriginalDistance < 301.0) {
                        DistanceIndex = 1;
                    } else if (this.CurrentWave.EnemyOriginalDistance > 300.0 && this.CurrentWave.EnemyOriginalDistance < 501.0) {
                        DistanceIndex = 2;
                    } else if (this.CurrentWave.EnemyOriginalDistance > 500.0 && this.CurrentWave.EnemyOriginalDistance < 701.0) {
                        DistanceIndex = 3;
                    } else if (this.CurrentWave.EnemyOriginalDistance > 700.0) {
                        DistanceIndex = 4;
                    }
                    int[] nArray = GuessFactors[this.GuessFactor];
                    int n = DistanceIndex;
                    nArray[n] = nArray[n] + 1;
                    --this.i;
                }
                ++this.i;
            }
        }
        this.lastBearing = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
        this.lastVelocity = e.getVelocity();
    }

    public void MoveScan(ScannedRobotEvent e) {
        double y;
        this.hisOldDir = this.hisDir;
        int n = this.hisDir = e.getVelocity() < 0.0 ? 1 : -1;
        if (this.anti == 0) {
            this.anti = e.getBearingRadians() - 1.5707963267948966 < e.getBearingRadians() + 1.5707963267948966 ? 1 : -1;
        }
        double angle = e.getBearingRadians() - 1.5707963267948966 * (double)this.anti;
        double x = this.getX() + Math.sin(this.getHeadingRadians() + e.getBearingRadians()) * e.getDistance();
        double toWall = x;
        if (toWall > (y = this.getY() + Math.cos(this.getHeadingRadians() + e.getBearingRadians()) * e.getDistance())) {
            toWall = y;
        }
        if (toWall > this.getBattleFieldHeight() - y) {
            toWall = this.getBattleFieldHeight() - y;
        }
        if (toWall > this.getBattleFieldWidth() - x) {
            toWall = this.getBattleFieldWidth() - x;
        }
        if (e.getDistance() < 300.0) {
            angle -= 0.39269908169872414 * (double)(this.getDistanceRemaining() > 0.0 ? 1 : -1);
        } else if (e.getDistance() > 500.0 || e.getDistance() > toWall) {
            angle += 0.39269908169872414 * (double)(this.getDistanceRemaining() > 0.0 ? 1 : -1);
        }
        angle = Utils.normalRelativeAngle((double)angle);
        if (angle < (double)this.max && angle > (double)this.min || this.max == 90 && (angle < 90.0 || angle > 270.0)) {
            this.setTurnRightRadians(angle);
        }
    }

    public void goTo(double x, double y) {
        double AngleToMove = Math.toDegrees(Math.atan2(Math.min(Math.max(50.0, x), this.getBattleFieldWidth() - 50.0) - this.getX(), Math.min(Math.max(50.0, y), this.getBattleFieldHeight() - 50.0) - this.getY()));
        AngleToMove -= this.getHeading();
        while (AngleToMove > 180.0) {
            AngleToMove -= 360.0;
        }
        while (AngleToMove < -180.0) {
            AngleToMove += 360.0;
        }
        this.setTurnRight(AngleToMove);
        this.setAhead(Point2D.distance(x, y, this.getX(), this.getY()));
    }

    public void reverse() {
        this.lastReverse = this.getTime();
        this.dir *= -1;
        this.setAhead(Double.POSITIVE_INFINITY * (double)this.dir);
    }

    int[][] restoreFactors(String enemyName) {
        int[][] factors = new int[51][5];
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(this.getDataFile(enemyName + ".zip")));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            factors = (int[][])in.readObject();
            in.close();
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return factors;
    }

    void saveFactors(String enemyName, int[][] aimFactors) {
        this.i = 0;
        while (this.i < 51) {
            this.out.println("" + this.i + ',' + aimFactors[this.i][0] + ',' + aimFactors[this.i][1] + ',' + aimFactors[this.i][2] + ',' + aimFactors[this.i][3] + ',' + aimFactors[this.i][4]);
            this.j = 0;
            while (this.j < 5) {
                if (aimFactors[this.i][this.j] > 255) {
                    this.k = 0;
                    while (this.k < 51) {
                        this.l = 0;
                        while (this.l < 5) {
                            Recrimpo.GuessFactors[this.k][this.l] = GuessFactors[this.k][this.l] / 2;
                            ++this.l;
                        }
                        ++this.k;
                    }
                    --this.j;
                }
                ++this.j;
            }
            ++this.i;
        }
        try {
            ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(enemyName + ".zip")));
            zipout.putNextEntry(new ZipEntry(enemyName));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(aimFactors);
            out.flush();
            zipout.closeEntry();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error saving factors:" + e);
        }
    }

    private final /* synthetic */ void this() {
        this.lastTime = -5.0;
        this.lastReverse = -500.0;
        this.EnemyLocation = new Point2D.Double();
        this.hisDir = 1;
        this.hisOldDir = 1;
        this.anti = 0;
        this.max = 1000;
        this.min = -1000;
        this.Waves = new Vector(0);
        this.dir = 1;
    }

    public Recrimpo() {
        this.this();
    }

    class Wave {
        long FiredTime;
        Point2D FiredPosition;
        Point2D EnemyOriginalPosition;
        double Power;
        double EnemyOriginalDistance;
        double EnemyOriginalBearing;
        double EnemyOriginalVelocity;
        boolean clockwise;

        public boolean Hit(Point2D EnemyCurrent, int Index) {
            if (this.FiredPosition.distance(EnemyCurrent) <= this.getBulletTime() * (20.0 - (double)3 * this.Power)) {
                Recrimpo.this.Waves.removeElementAt(Index);
                return true;
            }
            return false;
        }

        public double getBulletTime() {
            return Recrimpo.this.getTime() - this.FiredTime;
        }

        Wave(long FiredTime, Point2D FiredPosition, double Power, double EnemyOriginalDistance, double EnemyOriginalBearing, double EnemyOriginalVelocity, Point2D EnemyOriginalPosition, boolean clockwise) {
            this.FiredTime = FiredTime;
            this.FiredPosition = FiredPosition;
            this.Power = Power;
            this.EnemyOriginalDistance = EnemyOriginalDistance;
            this.EnemyOriginalBearing = EnemyOriginalBearing;
            this.EnemyOriginalVelocity = EnemyOriginalVelocity;
            this.EnemyOriginalPosition = EnemyOriginalPosition;
            this.clockwise = clockwise;
        }
    }
}

