/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.muse.base.StaticStorage;
import ags.rougedc.waves.EnemyWave;
import ags.rougedc.waves.EnemyWaveManager;
import ags.util.KdTree;
import ags.util.points.AbsolutePoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class EnemyTargetingWatcher {
    private final EnemyWaveManager ewm;
    private boolean need_wave_dangers_updated = false;
    private Map<String, KdTree<Double>> stats = (Map)StaticStorage.get("ETWStats");
    private static final int segments = 2;
    private static final double[] segmentweights = new double[]{0.49533494812047046, 0.47888435173735894, 0.024915706369010034, 8.64993773160576E-4};

    public EnemyTargetingWatcher(EnemyWaveManager ewm) {
        if (this.stats == null) {
            this.stats = new HashMap<String, KdTree<Double>>();
            StaticStorage.put("ETWStats", this.stats);
        }
        this.ewm = ewm;
    }

    public void handleEvents(Iterable<Event> i) {
        for (Event e : i) {
            if (e instanceof HitByBulletEvent) {
                this.handleHit((HitByBulletEvent)e);
            }
            if (!(e instanceof BulletHitBulletEvent)) continue;
            this.handleHit((BulletHitBulletEvent)e);
        }
        for (EnemyWave wave : this.ewm.getAll()) {
            if (!this.need_wave_dangers_updated && wave.getDangerPoints() != null) continue;
            wave.setDangerPoints(this.getDangerFactors(wave));
        }
        for (EnemyWave wave : this.ewm.getAllHeat()) {
            if (!this.need_wave_dangers_updated && wave.getDangerPoints() != null) continue;
            wave.setDangerPoints(this.getDangerFactors(wave));
        }
        this.need_wave_dangers_updated = false;
    }

    public double[][] getDangerFactors(EnemyWave wave) {
        String sourcename = wave.getSource().name;
        if (!this.stats.containsKey(sourcename)) {
            return new double[2][0];
        }
        double[] p = this.getSegmentation(wave);
        List<KdTree.Entry<Double>> l = this.stats.get(sourcename).nearestNeighbor(p, 20, false);
        double nweight = 50 / l.size();
        double ptotal = 0.0;
        double[][] list = new double[2][l.size()];
        int i = 0;
        while (i < l.size()) {
            list[0][i] = (Double)l.get((int)i).value;
            double pweight = 1.0 + Math.sqrt(l.get((int)i).distance);
            ptotal += pweight;
            list[1][i] = nweight / pweight;
            ++i;
        }
        ptotal /= (double)l.size();
        i = 0;
        while (i < l.size()) {
            double[] dArray = list[1];
            int n = i++;
            dArray[n] = dArray[n] / ptotal;
        }
        return list;
    }

    private double[] getSegmentation(EnemyWave wave) {
        double[] segmentdata = new double[2];
        double lateralVelocity = wave.staticr.magnitude * Math.sin(wave.staticr.getDirection() - wave.getHOTAngle());
        double advancingVelocity = wave.staticr.magnitude * -Math.cos(wave.staticr.getDirection() - wave.getHOTAngle());
        segmentdata[0] = Math.abs(lateralVelocity);
        segmentdata[1] = advancingVelocity;
        int x = 0;
        while (x < 2) {
            int n = x;
            segmentdata[n] = segmentdata[n] * segmentweights[x];
            ++x;
        }
        return segmentdata;
    }

    private void hitAt(EnemyWave wave, AbsolutePoint bulletpos) {
        double guessfactor = wave.getGuessFactor(bulletpos);
        String sourcename = wave.getSource().name;
        double[] p = this.getSegmentation(wave);
        if (!this.stats.containsKey(sourcename)) {
            this.stats.put(sourcename, new KdTree.SqrEuclid(2, null));
        }
        this.stats.get(sourcename).addPoint(p, guessfactor);
        this.need_wave_dangers_updated = true;
    }

    private void handleHit(HitByBulletEvent hit) {
        this.handleHit(hit.getBullet(), true);
    }

    private void handleHit(BulletHitBulletEvent hit) {
        this.handleHit(hit.getHitBullet(), false);
    }

    private void handleHit(Bullet bullet, boolean realhit) {
        EnemyWave wave = this.findMatchingWave(bullet);
        if (wave != null) {
            AbsolutePoint bulletpos = AbsolutePoint.fromXY(bullet.getX(), bullet.getY());
            this.hitAt(wave, bulletpos);
            this.ewm.remove(wave, realhit);
        } else {
            System.out.println("Warning: Hit not matched!");
        }
    }

    private EnemyWave findMatchingWave(Bullet bullet) {
        AbsolutePoint bulletpos = AbsolutePoint.fromXY(bullet.getX(), bullet.getY());
        List<EnemyWave> waves = this.ewm.getAll();
        for (EnemyWave wave : waves) {
            if (!wave.getSource().name.equals(bullet.getName()) || Math.abs(wave.getPower() - bullet.getPower()) > 0.01 || !wave.isNear(bulletpos, 22.0) || !Utils.isNear((double)wave.getAngleTo(bulletpos), (double)bullet.getHeadingRadians())) continue;
            return wave;
        }
        return null;
    }
}

