/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.muse.base.Rules;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

public class WallSmoother {
    private static final double WALL_STICK = 155.0;
    private Rectangle2D.Double _fieldRect;

    public WallSmoother(Rules rules) {
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, rules.BATTLEFIELD_WIDTH - 36.0, rules.BATTLEFIELD_HEIGHT - 36.0);
    }

    public double smoothAngle2(AbsolutePoint p, double angle, RelativePoint velocity) {
        double newd1 = this.smoothAngle(p.x, p.y, angle, 1);
        double newd2 = this.smoothAngle(p.x, p.y, angle, -1);
        double currentDirection = velocity.magnitude >= 0.0 ? velocity.direction : Utils.normalAbsoluteAngle((double)(velocity.direction + Math.PI));
        double dd1 = Math.abs(Utils.normalRelativeAngle((double)(newd1 - currentDirection)));
        double dd2 = Math.abs(Utils.normalRelativeAngle((double)(newd2 - currentDirection)));
        angle = dd1 <= dd2 ? newd1 : newd2;
        return angle;
    }

    public double smoothAngle(double x, double y, double angle, int orientation) {
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        double testX = x + Math.sin(angle) * 155.0;
        double testY = y + Math.cos(angle) * 155.0;
        double wallDistanceX = Math.min(x - 18.0, this._fieldRect.width - x + 18.0);
        double wallDistanceY = Math.min(y - 18.0, this._fieldRect.height - y + 18.0);
        double testDistanceX = Math.min(testX - 18.0, this._fieldRect.width - testX + 18.0);
        double testDistanceY = Math.min(testY - 18.0, this._fieldRect.height - testY + 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!this._fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                if (!(((angle -= (angle + Math.PI * 2) % 1.5707963267948966) + Math.PI * 2) % Math.PI < 0.1) && !(Math.PI - (angle + Math.PI * 2) % Math.PI < 0.1)) {
                    angle += 1.5707963267948966;
                }
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                if (((angle -= (angle + Math.PI * 2) % 1.5707963267948966) + Math.PI * 2) % Math.PI < 0.1 || Math.PI - (angle + Math.PI * 2) % Math.PI < 0.1) {
                    angle += 1.5707963267948966;
                }
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / 155.0)) + 0.005)) * 155.0;
            testY = y + Math.cos(angle) * 155.0;
            testDistanceX = Math.min(testX - 18.0, this._fieldRect.width - testX + 18.0);
            testDistanceY = Math.min(testY - 18.0, this._fieldRect.height - testY + 18.0);
        }
        return angle;
    }
}

