/*
 * Decompiled with CFR 0.152.
 */
package jdg.tools;

import java.awt.geom.Point2D;
import jdg.tools.RobotState;

public class BotTrigo {
    public static final double FULLFIRE_MAX_DIST = 25.0;
    public static final double LOWFIRE_MAX_DIST = 800.0;

    public static double fixAngle(double angle) {
        while (angle < 0.0) {
            angle += 360.0;
        }
        while (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public static Point2D getPosition(Point2D.Double r, double bearing, double distance) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double tx = distance * Math.cos(radBearing);
        double ty = distance * Math.sin(radBearing);
        return new Point2D.Double(r.getX() + tx, r.getY() + ty);
    }

    public static Point2D getPosition(Point2D r, double bearing, double distance) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double tx = distance * Math.cos(radBearing);
        double ty = distance * Math.sin(radBearing);
        return new Point2D.Double(r.getX() + tx, r.getY() + ty);
    }

    public static double getDistanceTo(Point2D a, Point2D b) {
        return BotTrigo.getDistanceTo(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static double getDistanceTo(Point2D.Double r, double x2, double y2) {
        return BotTrigo.getDistanceTo(r.getX(), r.getY(), x2, y2);
    }

    public static double getDistanceTo(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double getHeadingTo(Point2D.Double r, Point2D target) {
        return BotTrigo.getHeadingTo(r, target.getX(), target.getY());
    }

    public static double getHeadingTo(Point2D.Double r, double tx, double ty) {
        return BotTrigo.angle(r, new Point2D.Double(tx, ty));
    }

    public static double angle(Point2D.Double a, Point2D b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        double angle = 0.0;
        angle = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return Math.toDegrees(-angle + 1.5707963267948966);
    }

    public static double computeFirePower(RobotState r, MovingStrat strat, double distance, double accuracy) {
        if (strat == MovingStrat.STATIC) {
            return 3.0;
        }
        if (accuracy > 0.7) {
            return 3.0;
        }
        if (r.getEnergy() < 20.0) {
            return 0.1;
        }
        if (distance < 25.0) {
            return 3.0;
        }
        if (distance > 800.0) {
            return 0.0;
        }
        double distPercent = (distance - 25.0) / 775.0;
        return Math.max(0.1, 3.0 - distPercent * 3.0);
    }

    public static enum MovingStrat {
        UNKONWN,
        STATIC,
        LINEAR,
        CIRCLE,
        RANDOM;

    }
}

