/*
 * Decompiled with CFR 0.152.
 */
package as;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public class FrankTheTank
extends TeamRobot {
    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setBodyColor(new Color(85, 107, 47));
        this.setRadarColor(new Color(139, 134, 75));
        this.setGunColor(new Color(0, 0, 0));
        this.setBulletColor(new Color(255, 255, 255));
        while (this.getOthers() > 1) {
            this.standardroutine();
        }
        while (this.getOthers() == 1) {
            this.verfolgungsroutine();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (!this.isTeammate(e.getName())) {
            if (this.getOthers() == 1) {
                double bearingFromGun = this.winkelBerechnung(e.getBearing() + this.getHeading() - this.getGunHeading());
                this.vorzielen(e, 3.0);
                this.verfolgung(e.getBearing(), e.getDistance());
            }
            double feuerstaerke = 1.0;
            if (e.getDistance() <= 600.0) {
                if (e.getDistance() > 200.0 && e.getDistance() < 400.0) {
                    feuerstaerke = 2.0;
                } else if (e.getDistance() < 200.0) {
                    feuerstaerke = 3.0;
                }
                this.vorzielen(e, feuerstaerke);
                this.setAdjustRadarForGunTurn(true);
            } else {
                this.turnRadarRight(90.0);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnLeft(90.0);
        this.setAhead(200.0);
        if (this.isTeammate(e.getName())) {
            try {
                this.broadcastMessage((Serializable)((Object)"STOP FIRE"));
            }
            catch (IOException ex) {
                this.out.println("Fehler beim Senden der Nachricht von" + this.getName());
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        if (this.getOthers() == 1) {
            // empty if block
        }
        if (this.getOthers() > 1) {
            if (e.getBearing() <= 90.0 && e.getBearing() >= -90.0) {
                this.setTurnRight(0.0);
                this.setBack(200.0);
            }
            if (e.getBearing() > 90.0) {
                this.setTurnRight(0.0);
                this.setAhead(200.0);
            }
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.getOthers() == 1 && e.getEnergy() < this.getEnergy() - 10.0) {
            this.setTurnRadarRight(this.winkelBerechnung(e.getBearing() + this.getHeading() - this.getGunHeading()));
            this.setTurnGunRight(this.winkelBerechnung(e.getBearing() + this.getHeading() - this.getGunHeading()));
            this.fire(3.0);
        }
        if (this.getOthers() > 1 && !this.isTeammate(e.getName())) {
            if (e.getEnergy() < this.getEnergy() - 10.0) {
                this.setTurnRadarRight(this.winkelBerechnung(e.getBearing() + this.getHeading() - this.getGunHeading()));
                this.setTurnGunRight(this.winkelBerechnung(e.getBearing() + this.getHeading() - this.getGunHeading()));
                this.fire(3.0);
            } else {
                this.turnLeft(90.0 - e.getBearing());
                this.setAhead(100.0);
            }
        }
    }

    public void onWin(WinEvent e) {
        for (int i = 0; i < 10; ++i) {
            this.setBodyColor(new Color(255, 215, 0));
            this.setGunColor(new Color(255, 215, 0));
            this.setRadarColor(new Color(255, 215, 0));
            this.turnRight(20.0);
            this.turnGunLeft(20.0);
        }
    }

    public void onMessageRecieved(MessageEvent e) {
        if (e.getMessage().equals("STOP FIRE")) {
            this.run();
        }
    }

    public void standardroutine() {
        this.turnRadarRight(360.0);
        this.setAhead(200.0);
        this.turnRight(90.0);
    }

    public void verfolgungsroutine() {
        this.turnRadarRight(360.0);
    }

    public void verfolgung(double bearing, double distance) {
        this.setTurnGunRight(this.winkelBerechnung(bearing + this.getHeading() - this.getGunHeading()));
        this.setTurnRadarRight(this.winkelBerechnung(this.getGunHeading() - this.getRadarHeading()));
        this.setTurnRight(bearing);
        if (distance > 90.0) {
            this.setAhead(distance - 85.0);
        }
        if (distance < 80.0) {
            this.setBack(15.0);
        }
    }

    public double winkelBerechnung(double winkel) {
        double hilfswinkel;
        if (winkel > -180.0 && winkel <= 180.0) {
            return winkel;
        }
        for (hilfswinkel = winkel; hilfswinkel <= -180.0; hilfswinkel += 360.0) {
        }
        while (hilfswinkel > 180.0) {
            hilfswinkel -= 360.0;
        }
        return hilfswinkel;
    }

    public void vorzielen(ScannedRobotEvent e, double feuerstaerke) {
        double meinX = this.getX();
        double meinY = this.getY();
        double richtung_zu_feind = e.getBearingRadians() + this.getHeadingRadians();
        double feindX = meinX + e.getDistance() * Math.sin(richtung_zu_feind);
        double feindY = meinY + e.getDistance() * Math.cos(richtung_zu_feind);
        double ausrichtung_feind = e.getHeadingRadians();
        double v_feind = e.getVelocity();
        int zeit = 0;
        double naechstes_feindX = feindX;
        double naechstes_feindY = feindY;
        double spielFeldHoehe = this.getBattleFieldHeight();
        double spielFeldBreite = this.getBattleFieldWidth();
        while ((double)(++zeit) * (20.0 - 3.0 * feuerstaerke) < Point2D.Double.distance(meinX, meinY, naechstes_feindX, naechstes_feindY)) {
            naechstes_feindY += v_feind * Math.cos(ausrichtung_feind);
            if (!((naechstes_feindX += v_feind * Math.sin(ausrichtung_feind)) < 18.0 || naechstes_feindY < 18.0 || naechstes_feindX > spielFeldHoehe - 18.0) && !(naechstes_feindY > spielFeldBreite - 18.0)) continue;
            naechstes_feindX = Math.min(Math.max(17.9, naechstes_feindX), spielFeldBreite - 17.9);
            naechstes_feindY = Math.min(Math.max(17.9, naechstes_feindY), spielFeldHoehe - 17.9);
            break;
        }
        double dx = naechstes_feindX - meinX;
        double dy = naechstes_feindY - meinY;
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(dx, dy));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(richtung_zu_feind - this.getRadarHeadingRadians())));
        this.turnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.fire(feuerstaerke);
    }
}

