/*
 * Decompiled with CFR 0.152.
 */
package panzer;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import panzer.Cerebro;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Panzer
extends AdvancedRobot {
    private String objetivo;
    private int turnosSinEncontrarObj = 0;
    private int balasFalladas = 0;
    private boolean tipoDisparo = true;
    private double anguloObjetivo0 = 0.0;
    private double velocidadObjetivo1 = 0.0;
    private double anguloRespectoObjetivo2 = 0.0;
    private double distanciaObjetivo3 = 0.0;
    private double energiaObjetivo = 0.0;
    private double energiaRestante4 = 0.0;
    private double velocidadActual5 = 0.0;
    private double anguloActualTanque6 = 0.0;
    private double anguloGiroCanonS = 0.0;
    private double tipoDisparoS0 = 0.0;
    private double potenciaFuegoS1 = 0.0;
    private double dispararS2 = 0.0;
    private double anguloRadarS = 0.0;
    private double recibiendoDano7 = 0.0;
    private double anguloBalaEnemigo8 = 0.0;
    private double velocidadBalaEnemigo9 = 0.0;
    private double anguloRespectoBalaEnemigo10 = 0.0;
    private double tocandoPared11 = 0.0;
    private double anguloMuro12 = 0.0;
    private double anguloGiroTanqueS3 = 0.0;
    private double avanzarS4 = 0.0;
    Cerebro red;

    public void run() {
        this.setBodyColor(Color.BLACK);
        this.setGunColor(Color.BLACK);
        this.setRadarColor(Color.BLACK);
        this.setBulletColor(Color.WHITE);
        this.setScanColor(Color.BLACK);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.objetivo = null;
        boolean dataIsLoaded = false;
        while (!dataIsLoaded) {
            try {
                this.red = this.cargarCerebro("Cerebro.crb");
                dataIsLoaded = true;
            }
            catch (Exception exception) {}
        }
        while (true) {
            ++this.turnosSinEncontrarObj;
            if (this.objetivo == null) {
                this.turnosSinEncontrarObj = 0;
            }
            if (this.turnosSinEncontrarObj >= 20) {
                this.objetivo = null;
                this.turnosSinEncontrarObj = 0;
            }
            this.energiaRestante4 = this.getEnergy();
            this.velocidadActual5 = this.getVelocity();
            this.anguloActualTanque6 = this.getHeading();
            this.recibiendoDano7 -= 1.0;
            if (this.recibiendoDano7 < 0.0) {
                this.recibiendoDano7 = 0.0;
            }
            this.tocandoPared11 -= 1.0;
            if (this.tocandoPared11 < 0.0) {
                this.tocandoPared11 = 0.0;
            }
            this.red.entradas[0] = this.anguloObjetivo0;
            this.red.entradas[1] = this.velocidadObjetivo1;
            this.red.entradas[2] = this.anguloRespectoObjetivo2;
            this.red.entradas[3] = this.distanciaObjetivo3;
            this.red.entradas[4] = this.energiaRestante4;
            this.red.entradas[5] = this.velocidadActual5;
            this.red.entradas[6] = this.anguloActualTanque6;
            this.red.entradas[7] = this.recibiendoDano7;
            this.red.entradas[8] = this.anguloBalaEnemigo8;
            this.red.entradas[9] = this.velocidadBalaEnemigo9;
            this.red.entradas[10] = this.anguloRespectoBalaEnemigo10;
            this.red.entradas[11] = this.tocandoPared11;
            this.red.entradas[12] = this.anguloMuro12;
            this.red.obtenerSalida(this.red.entradas);
            this.anguloGiroCanonS = this.anguloRespectoObjetivo2;
            this.tipoDisparoS0 = this.red.salidas[0];
            this.potenciaFuegoS1 = this.red.salidas[1];
            this.dispararS2 = this.red.salidas[2];
            if (this.objetivo == null) {
                this.anguloRadarS = Double.POSITIVE_INFINITY;
            }
            this.anguloGiroTanqueS3 = this.red.salidas[3];
            this.avanzarS4 = this.red.salidas[4];
            this.EjecutarAcciones();
        }
    }

    private void EjecutarAcciones() {
        this.setTurnGunRightRadians(this.anguloGiroCanonS);
        this.setTurnRight(this.anguloGiroTanqueS3);
        this.setAhead(this.avanzarS4);
        this.setTurnRadarRightRadians(this.anguloRadarS);
        if (this.dispararS2 > 1.0 && this.objetivo != null && (this.getEnergy() > 10.0 || this.distanciaObjetivo3 < 20.0 || this.energiaObjetivo == 0.0)) {
            this.setFire(this.potenciaFuegoS1);
        }
        this.execute();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.objetivo == null || e.getDistance() < this.distanciaObjetivo3) {
            this.objetivo = e.getName();
        }
        if (this.objetivo != null && e.getName().equals(this.objetivo)) {
            this.turnosSinEncontrarObj = 0;
            this.anguloObjetivo0 = e.getHeading();
            this.velocidadObjetivo1 = e.getVelocity();
            this.distanciaObjetivo3 = e.getDistance();
            this.energiaObjetivo = e.getEnergy();
            if (this.balasFalladas > 8) {
                this.tipoDisparo = !this.tipoDisparo;
                this.balasFalladas = 0;
            }
            if (this.tipoDisparo && this.distanciaObjetivo3 > 20.0) {
                this.anguloRespectoObjetivo2 = e.getBearingRadians() + this.getHeadingRadians();
                this.anguloRespectoObjetivo2 = Utils.normalRelativeAngle((double)(this.anguloRespectoObjetivo2 - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - this.anguloRespectoObjetivo2) / 13.0));
            } else {
                this.anguloRespectoObjetivo2 = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians() - this.getGunHeadingRadians()));
            }
            this.anguloRadarS = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians()));
            double giroExtra = Math.min(Math.atan(36.0 / e.getDistance()), 0.7853981633974483);
            this.anguloRadarS = this.anguloRadarS < 0.0 ? (this.anguloRadarS -= giroExtra) : (this.anguloRadarS += giroExtra);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.recibiendoDano7 = e.getPower();
        this.anguloBalaEnemigo8 = e.getHeading();
        this.velocidadBalaEnemigo9 = e.getVelocity();
        this.anguloRespectoBalaEnemigo10 = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
    }

    public void onHitWall(HitWallEvent e) {
        this.tocandoPared11 += 5.0;
        this.anguloMuro12 = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++this.balasFalladas;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.balasFalladas = 0;
    }

    public Cerebro cargarCerebro(String rutaCerebro) {
        Cerebro crb2;
        try {
            ObjectInputStream entrada = new ObjectInputStream(new FileInputStream(this.getDataFile(rutaCerebro)));
            crb2 = (Cerebro)entrada.readObject();
            entrada.close();
        }
        catch (Exception ex) {
            System.out.println("No existe el cerebro " + rutaCerebro + ", se creara uno nuevo");
            Cerebro crb2 = new Cerebro(15, 6, 10);
            crb2.InicializarNuevoCerebro();
            return crb2;
        }
        return crb2;
    }
}

