/*
 * Decompiled with CFR 0.152.
 */
package syl.scan;

import java.util.Arrays;
import java.util.Enumeration;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.scan.ScanStrategy;
import syl.util.Angle;
import syl.util.Coordinate;

public class MultipleTargetScanStrategy
extends ScanStrategy {
    private double leftBorderAngle;
    private double rightBorderAngle;
    private boolean hasScannedAll = false;

    public MultipleTargetScanStrategy(BaseRobot robot) {
        super(robot);
    }

    public void initialize() {
        this.robot.setTurnRadarLeft(360.0);
    }

    public void cleanUp() {
    }

    public void doScan() {
        if (!this.hasScannedAll && this.robot.getRadarTurnRemaining() == 0.0) {
            this.hasScannedAll = true;
        }
        if (!this.hasScannedAll) {
            return;
        }
        this.updateBorders();
        if (this.rightBorderAngle < this.leftBorderAngle) {
            if (this.rightBorderAngle < this.robot.getRadarHeading() && this.robot.getRadarHeading() < this.leftBorderAngle) {
                this.goToClosestBorder();
            }
        } else if (!(!(this.leftBorderAngle < this.rightBorderAngle) || this.rightBorderAngle >= this.robot.getRadarHeading() && this.robot.getRadarHeading() >= this.leftBorderAngle)) {
            this.goToClosestBorder();
        }
    }

    private void updateBorders() {
        double[] angles = this.getAngles();
        double maxAngle = 0.0;
        int i = 0;
        while (i < angles.length) {
            double angle;
            if (i == 0) {
                angle = angles[0] + (360.0 - angles[angles.length - 1]);
                if (angle > maxAngle) {
                    maxAngle = angle;
                    this.leftBorderAngle = angles[i];
                    this.rightBorderAngle = angles[angles.length - 1];
                }
            } else {
                angle = angles[i] - angles[i - 1];
                if (angle > maxAngle) {
                    maxAngle = angle;
                    this.leftBorderAngle = angles[i];
                    this.rightBorderAngle = angles[i - 1];
                }
            }
            ++i;
        }
    }

    private double[] getAngles() {
        Coordinate robotCoordinate = this.robot.getCoordinate();
        double[] angles = new double[this.robot.getEnemyMap().getNumberOfEnemies()];
        Enumeration enumeration = this.robot.getEnemyMap().getAllEnemies();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            Enemy enemy = (Enemy)enumeration.nextElement();
            Coordinate enemyCoordinate = enemy.getCoordinate();
            angles[index] = Angle.toAbsoluteAngle(robotCoordinate.getAngle(enemyCoordinate));
            ++index;
        }
        Arrays.sort(angles);
        return angles;
    }

    private void goToClosestBorder() {
        double radarAngle = this.robot.getRadarHeading();
        if (Math.abs(radarAngle - this.rightBorderAngle) < Math.abs(radarAngle - this.leftBorderAngle)) {
            this.robot.setTurnRadarLeft(Double.MAX_VALUE);
        } else {
            this.robot.setTurnRadarRight(Double.MAX_VALUE);
        }
    }
}

