/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils.geom;

import java.awt.geom.Point2D;

public class LineSeg {
    public double m;
    public double b;
    public double xMin;
    public double xMax;
    public double yMin;
    public double yMax;
    public double x1;
    public double y1;
    public double x2;
    public double y2;

    public LineSeg(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            this.m = Double.POSITIVE_INFINITY;
            this.b = Double.NaN;
            this.xMin = this.xMax = x1;
        } else {
            this.m = (y2 - y1) / (x2 - x1);
            this.b = y1 - this.m * x1;
            this.xMin = Math.min(x1, x2);
            this.xMax = Math.max(x1, x2);
        }
        this.yMin = Math.min(y1, y2);
        this.yMax = Math.max(y1, y2);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public LineSeg(Point2D.Double p1, Point2D.Double p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public Point2D.Double intersects(LineSeg seg) {
        if (this.m == seg.m || this.b == Double.NaN && seg.b == Double.NaN) {
            return null;
        }
        if (this.b == Double.NaN || seg.b == Double.NaN) {
            LineSeg seg1 = new LineSeg(this.y1, this.x1, this.y2, this.x2);
            LineSeg seg2 = new LineSeg(seg.y1, seg.x1, seg.y2, seg.x2);
            Point2D.Double inverse = seg1.intersects(seg2);
            return new Point2D.Double(inverse.y, inverse.x);
        }
        double x = (seg.b - this.b) / (this.m - seg.m);
        double y = this.m * x + this.b;
        return new Point2D.Double(x, y);
    }
}

