/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.Area;
import bjl.BattleField;
import bjl.MoveDemand;
import bjl.SuperBlip;
import bjl.move.MoveStrategy;
import java.util.Enumeration;
import java.util.Hashtable;

public class MoveStrategyManager {
    private Hashtable strategies;
    private MoveStrategy curStrategy;
    private int type;
    private double lastEnergy;
    private double lastDamage;
    private long changeTime;

    public void addStrategy(MoveStrategy s) {
        s.enabled = true;
        this.strategies.put(s.toString(), s);
    }

    public void removeStrategy(String name) {
        this.strategies.remove(name);
    }

    public void enableStrategy(String name, boolean enable) {
        ((MoveStrategy)this.strategies.get((Object)name)).enabled = enable;
    }

    public void reset() {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            MoveStrategy ms = (MoveStrategy)e.nextElement();
            ms.enabled = true;
            ms.reset();
        }
    }

    public void setGroup(String group) {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            MoveStrategy ms = (MoveStrategy)e.nextElement();
            if (ms.isInGroup(group)) continue;
            ms.enabled = false;
        }
    }

    public void setData(Object data) {
        Enumeration e = this.strategies.elements();
        if (data instanceof Area) {
            BattleField.println("area: " + ((Area)data).minx);
        }
        while (e.hasMoreElements()) {
            ((MoveStrategy)e.nextElement()).setData(data);
        }
    }

    public void reInit() {
        this.curStrategy = null;
        this.changeTime = 0L;
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            MoveStrategy ms = (MoveStrategy)e.nextElement();
            ms.reInit();
        }
    }

    public void onHit() {
    }

    public void onFinish() {
        SuperBlip me = BattleField.getMe();
        double bias = (BattleField.getDamage() - this.lastDamage + (me.energy - this.lastEnergy)) / 100.0;
        this.curStrategy.changeBias(bias);
        BattleField.println("Time delta " + (me.time - this.changeTime) + " bias change " + bias);
    }

    public MoveDemand getMoveDemand() {
        boolean isCurStrategy;
        SuperBlip me = BattleField.getMe();
        Enumeration e = this.strategies.elements();
        MoveStrategy ans = null;
        while (e.hasMoreElements()) {
            MoveStrategy s = (MoveStrategy)e.nextElement();
            if (!s.enabled || ans != null && !(s.getUsefulness(this.type) > ans.getUsefulness(this.type))) continue;
            ans = s;
        }
        if (this.curStrategy == null) {
            isCurStrategy = false;
        } else {
            boolean bl = false;
            if (this.curStrategy == ans) {
                bl = isCurStrategy = true;
            }
        }
        if (!isCurStrategy) {
            BattleField.println("Changing movement strategy to " + ans);
            if (this.curStrategy != null) {
                double bias = (BattleField.getDamage() - this.lastDamage + (me.energy - this.lastEnergy)) / 100.0;
                this.curStrategy.changeBias(bias);
                BattleField.println("Time delta " + (me.time - this.changeTime) + " bias change " + bias);
            }
            this.lastEnergy = me.energy;
            this.lastDamage = BattleField.getDamage();
            this.changeTime = me.time;
        }
        this.curStrategy = ans;
        MoveDemand dem = ans.getMoveDemand(isCurStrategy, this.type);
        return dem;
    }

    public MoveStrategyManager(int t) {
        this.type = t;
        this.strategies = new Hashtable();
    }
}

