/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.BattleField;
import bjl.Command;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.IndividualCommand;
import bjl.MoveStrategyManager;
import bjl.Plan;
import bjl.RadarStrategyManager;
import bjl.TargetStrategyManager;
import bjl.move.AntiGravity;
import bjl.move.AntiGravity2;
import bjl.move.BulletDodge;
import bjl.move.Circle;
import bjl.radar.FieldPortion;
import bjl.radar.OldestBot;
import bjl.radar.ScanTarget;
import bjl.radar.WholeField;
import bjl.strategy.Default;
import bjl.strategy.Melee;
import bjl.strategy.One;
import bjl.strategy.Search;
import bjl.strategy.Strategy;
import bjl.strategy.Win;
import bjl.target.DestroyLeader;
import bjl.target.KeepTarget;
import bjl.target.Nearest;
import bjl.target.Revenge;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StrategyManager {
    private static RadarStrategyManager radarMan;
    private static RadarStrategyManager radarMel;
    private static RadarStrategyManager radarOne;
    private static MoveStrategyManager moveMan;
    private static MoveStrategyManager moveMel;
    private static MoveStrategyManager moveOne;
    private static TargetStrategyManager targMan;
    private static TargetStrategyManager targMel;
    private static TargetStrategyManager targOne;
    private static Enemy scanTarget;
    private static Enemy curTarget;
    private static int type;
    private static Hashtable strategies;
    private static String curStrategy;

    public static void init(int t) {
        type = t;
        strategies = new Hashtable();
        StrategyManager.addStrategy(new Default());
        StrategyManager.addStrategy(new Win());
        StrategyManager.addStrategy(new One());
        StrategyManager.addStrategy(new Melee());
        StrategyManager.addStrategy(new Search());
        moveOne = new MoveStrategyManager(type);
        moveOne.addStrategy(new Circle());
        moveOne.addStrategy(new AntiGravity());
        moveOne.addStrategy(new AntiGravity2());
        moveOne.addStrategy(new BulletDodge());
        radarOne = new RadarStrategyManager();
        radarOne.addStrategy(new OldestBot());
        radarOne.addStrategy(new WholeField());
        radarOne.addStrategy(new ScanTarget());
        radarOne.addStrategy(new FieldPortion());
        targOne = new TargetStrategyManager();
        targOne.addStrategy(new KeepTarget());
        targOne.addStrategy(new Nearest());
        targOne.addStrategy(new DestroyLeader());
        targOne.addStrategy(new Revenge());
        moveMel = new MoveStrategyManager(type);
        moveMel.addStrategy(new Circle());
        moveMel.addStrategy(new AntiGravity());
        moveMel.addStrategy(new AntiGravity2());
        radarMel = new RadarStrategyManager();
        radarMel.addStrategy(new OldestBot());
        radarMel.addStrategy(new WholeField());
        radarMel.addStrategy(new ScanTarget());
        radarMel.addStrategy(new FieldPortion());
        targMel = new TargetStrategyManager();
        targMel.addStrategy(new KeepTarget());
        targMel.addStrategy(new Nearest());
        targMel.addStrategy(new DestroyLeader());
        targMel.addStrategy(new Revenge());
        StrategyManager.reInit();
    }

    private static final void addStrategy(Strategy s) {
        strategies.put(s.toString(), s);
    }

    private static final void removeStrategy(String name) {
        strategies.remove(name);
        if (curStrategy.equals(name)) {
            curStrategy = "";
        }
    }

    public static void reInit() {
        moveOne.reset();
        moveMel.reset();
        curStrategy = "";
        scanTarget = null;
        moveOne.reInit();
        moveMel.reInit();
    }

    private static final void addRadarCommands(Vector toSend) {
        int nummates;
        int numopponents = EnemyList.getNumOpponents();
        if (numopponents > (nummates = EnemyList.getNumTeammatesWithRadar())) {
            toSend.add(new Command(103));
        } else {
            int i = 0;
            int j = 0;
            int round = BattleField.getRound();
            long time = BattleField.getTime();
            Enemy[] mates = new Enemy[nummates];
            boolean[] used = new boolean[nummates];
            Enemy[] opponents = new Enemy[numopponents];
            Enemy[] targs = new Enemy[numopponents];
            Enumeration e = EnemyList.getHashElements();
            while (e.hasMoreElements()) {
                Enemy en = (Enemy)e.nextElement();
                if (en.isDead() || en.isTeammate() && en.getType() == 0) continue;
                if (en.isTeammate() && en.getType() != 0) {
                    mates[i++] = en;
                    continue;
                }
                if (en.getLastBlip().time <= time - 12L || en.getLastBlip().roundnum != round) continue;
                opponents[j++] = en;
            }
            i = 0;
            while (i < nummates) {
                used[i] = false;
                ++i;
            }
            i = 0;
            while (i < numopponents) {
                double dist = Double.MAX_VALUE;
                int index = 0;
                j = 0;
                while (j < nummates) {
                    if (!used[j] && mates[j].getLastPosition().dist(opponents[i].getLastPosition()) < dist) {
                        dist = mates[j].getLastPosition().dist(opponents[i].getLastPosition());
                        index = j;
                    }
                    ++j;
                }
                if (dist < 1175.0) {
                    used[index] = true;
                    targs[i] = mates[index];
                } else {
                    targs[i] = null;
                }
                ++i;
            }
            i = 0;
            while (i < numopponents) {
                if (targs[i] != null) {
                    toSend.add(new IndividualCommand(targs[i].getName(), new Command(102, (Serializable)((Object)opponents[i].getName()))));
                }
                ++i;
            }
            i = 0;
            while (i < nummates) {
                if (!used[i]) {
                    toSend.add(new IndividualCommand(mates[i].getName(), new Command(103)));
                }
                ++i;
            }
        }
    }

    private static final Vector getStrategyCommands() {
        Vector toSend;
        if (BattleField.getTime() > 9L || EnemyList.getNumAlive() - 1 == BattleField.getOthersAlive()) {
            Enumeration e = strategies.elements();
            Strategy ans = (Strategy)e.nextElement();
            while (e.hasMoreElements()) {
                Strategy s = (Strategy)e.nextElement();
                if (!(s.getUsefulness(curStrategy.equals(s.toString())) > ans.getUsefulness(curStrategy.equals(ans.toString())))) continue;
                ans = s;
            }
            boolean isCurStrategy = curStrategy.equals(ans.toString());
            toSend = ans.getCommands(isCurStrategy);
            if (!isCurStrategy) {
                BattleField.println("Changing overall strategy to " + ans);
            }
            curStrategy = ans.toString();
            StrategyManager.addRadarCommands(toSend);
        } else {
            toSend = new Vector();
        }
        return toSend;
    }

    private static final void setGroups(Vector groups) {
        Enumeration e = groups.elements();
        while (e.hasMoreElements()) {
            moveMan.setGroup((String)e.nextElement());
        }
    }

    public static void setStrategyData(Vector data, Vector groups) {
        BattleField.println("Setting strategy data");
        Enumeration e = data.elements();
        moveMan.reset();
        while (e.hasMoreElements()) {
            moveMan.setData(e.nextElement());
        }
        StrategyManager.setGroups(groups);
    }

    public static void setScanTarget(String name) {
        scanTarget = name == null ? null : EnemyList.getEnemy(name);
    }

    public static boolean haveScanTarget() {
        return scanTarget != null;
    }

    public static String getScanTarget() {
        if (scanTarget == null) {
            return "";
        }
        return scanTarget.getName();
    }

    public static Plan getPlan(boolean leader) {
        Plan p = new Plan();
        if (EnemyList.getNumOpponents() <= 1) {
            if (radarMan != radarOne) {
                BattleField.println("Changing to 1v1 strategies.");
            }
            radarMan = radarOne;
            moveMan = moveOne;
            targMan = targOne;
        } else {
            if (radarMan != radarMel) {
                BattleField.println("Changing to melee strategies.");
            }
            radarMan = radarMel;
            moveMan = moveMel;
            targMan = targMel;
        }
        p.commands = leader ? StrategyManager.getStrategyCommands() : new Vector();
        p.radarAngle = radarMan.getRadarAngle(scanTarget);
        p.move = moveMan.getMoveDemand();
        if (BattleField.getTargetPoint() == null) {
            p.target = targMan.getTarget(curTarget, false);
        }
        return p;
    }

    public static void setCurrentTarget(Enemy targ) {
        curTarget = targ;
    }

    public static String getCurrentTarget() {
        if (curTarget == null) {
            return "";
        }
        return curTarget.getName();
    }

    public static void onHit() {
        moveMan.onHit();
    }

    public static void onFinish() {
        EnemyList.dumpStats();
        moveMan.onFinish();
    }

    static {
        curTarget = null;
    }
}

