/*

 ________  ___  ___  _________  _________  ___  ___  _______   ________  ________         
|\   __  \|\  \|\  \|\___   ___\\___   ___\\  \|\  \|\  ___ \ |\   __  \|\   ___ \        
\ \  \|\ /\ \  \\\  \|___ \  \_\|___ \  \_\ \  \\\  \ \   __/|\ \  \|\  \ \  \_|\ \       
 \ \   __  \ \  \\\  \   \ \  \     \ \  \ \ \   __  \ \  \_|/_\ \   __  \ \  \ \\ \      
  \ \  \|\  \ \  \\\  \   \ \  \     \ \  \ \ \  \ \  \ \  \_|\ \ \  \ \  \ \  \_\\ \     
   \ \_______\ \_______\   \ \__\     \ \__\ \ \__\ \__\ \_______\ \__\ \__\ \_______\    
    \|_______|\|_______|    \|__|      \|__|  \|__|\|__|\|_______|\|__|\|__|\|_______|    
                                                                                          
Butthead - a nanobot that brutally head-butts the enemy by slugzilla                                                                                                                                                                             

Credits:

	It's based off of Caligula and Sabreur, but with changes to the movement mode selection.
	A huge thank you to all the contributors on the RoboWiki for your awesome tutorials and open source robots!

Released under the RWPCL
*/
package slugzilla;

import robocode.*;
import robocode.util.Utils;

public class ButtHead extends AdvancedRobot
{
	//Global variables
	static double direction;
	static double enemyEnergy;
	static double hits;
	static int movementMode;

	public void run() {
		setTurnRadarRightRadians(direction = 100000);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		//Local variables
		double absoluteBearing;
		double bearing;
		double lead;	
		
		//gun
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing = getHeadingRadians() + (bearing = e.getBearingRadians())) +
			(lead = Math.asin(e.getVelocity() / 14 * Math.sin(e.getHeadingRadians() - absoluteBearing))) - getGunHeadingRadians()));
			
		//movement		
		//oscillating			
		if(enemyEnergy > (enemyEnergy = e.getEnergy()) && movementMode == 1) {
			onHitWall(null);
		}
		//orbiting
		setAhead(direction);
		setTurnRightRadians(Math.cos(bearing - ((absoluteBearing = e.getDistance()) - 160) * (direction / 35000000)));
		
		//ramming
		if (movementMode > 1) {
			setTurnRightRadians(Math.tan(bearing += lead));
			setAhead(Math.cos(bearing) / 0);
		}
		
		//gun
		setFire(Math.min(2 + (100 / (int)absoluteBearing), enemyEnergy / 4));
	
		//radar
		setTurnRadarLeftRadians(getRadarTurnRemaining());
	}

	public void onBulletHit (BulletHitEvent e) {
		enemyEnergy -= 10;
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		if ((hits += (0.4)) > getRoundNum() + 2) {
			movementMode++;
			hits = 0;
		}
	}
	
	public void onHitWall(HitWallEvent e) {
		direction = -direction;
	}
}							