package suh.targeting;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.*;
import suh.util.*;

public class PatternMatchedGuessFactorTargeting extends Targeting {
    public static final int BINS = Wave.BINS;
    public static final int SAMPLE_NUM = 5;
    public static final int CACHE_SIZE = 8192;
    
    public static CacheMap<String, int[]> stats = new CacheMap<String, int[]>(CACHE_SIZE);
    public double lateralDirection;
    public ArrayList<Double> velocityHistory = new ArrayList<Double>();
    
    public PatternMatchedGuessFactorTargeting(AdvancedRobot self, FireManager fireManager) {
	super(self, fireManager);
    }
    
    @Override
    public void init() {
	Wave.target = new Point2D.Double();
	velocityHistory.clear();
    }
    
    @Override
    public String getName() {
	return "Pattern Matched Guess Factor";
    }

    @Override
    public double getAngle(ScannedRobotEvent e) {
	double angle, bearing, lateralVelocity;
	
	velocityHistory.add(0, lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - (bearing = self.getHeadingRadians() + e.getBearingRadians())));
	
	if(e.getVelocity() != 0) {
	    lateralDirection = Utility.sign(lateralVelocity);
	}
	
	if(velocityHistory.size() >= SAMPLE_NUM) {
	    int[] _stats;
	    String key;
	    
	    if(stats.containsKey(key = getKey(e))) {
		_stats = stats.get(key);
	    }
	    else {
		_stats = new int[BINS];
		stats.put(key, _stats);
	    }
	    
	    Wave wave;
	    self.addCustomEvent(wave = new Wave(
		self, 
		new Point2D.Double(self.getX(), self.getY()), 
		lateralDirection, 
		bearing, 
		Rules.getBulletSpeed(power), 
		Utility.maxEscapeAngle(Rules.getBulletSpeed(Math.min(Math.ceil(power), 3.0))), 
		_stats));
	    Wave.target = Utility.project(wave.origin, bearing, e.getDistance());
	    
	    angle = bearing + wave.mostVisitedBearingOffset();
	}
	else {
	    angle = bearing;
	}
	
	return angle;
    }
    
    protected String getKey(ScannedRobotEvent e) {
	StringBuilder key = new StringBuilder();
	
	key.append("p").append((int)power);
	key.append("v");
	for(int i = 0; i < SAMPLE_NUM; i++) {
	    double v = velocityHistory.get(i);
	    key.append((int)(Math.round(Math.abs(v)/2.0)));
	}
	key.append("d").append((int)(e.getDistance() / 200.0));
	
	return key.toString();
    }
}
