package sgp;
import robocode.*;
import java.util.*;

/**
 * Coordinate - a class by Simon Parker
 */

public class Coordinate implements java.io.Serializable
{
	private final double EQUALITY_THRESHOLD = 2.0;
	public double x;
	public double y;

	public Coordinate()
	{
		set(0, 0);
	}


	public Coordinate(double posX, double posY)
	{
		set(posX, posY);
	}

	public Coordinate(Coordinate coord)
	{
		set(coord.x, coord.y);
	}

	public boolean isEqualTo(Coordinate coordinate)
	{
		return
		(
			(Math.abs(x-coordinate.x) < EQUALITY_THRESHOLD) &&
			(Math.abs(y-coordinate.y) < EQUALITY_THRESHOLD)
		);
	}

	public void set(double posX, double posY)
	{
		x = posX;
		y = posY;
	}

	public void set(Coordinate coordinate)
	{
		set(coordinate.x, coordinate.y);
	}

	public Coordinate minus(Coordinate coordinate)
	{
		return new Coordinate(x - coordinate.x, y - coordinate.y);
	}

	public Coordinate plus(Coordinate coordinate)
	{
		return new Coordinate(x + coordinate.x, y + coordinate.y);
	}

	public Coordinate plus(double dx, double dy)
	{
		return new Coordinate(x + dx, y + dy);
	}

	public double length()
	{
		return Math.sqrt(x*x+y*y);
	}

	public double distanceFrom(Coordinate coordinate)
	{
		return minus(coordinate).length();
	}

	public Coordinate unit()
	{
		return new Coordinate( x / length(), y / length());
	}

	public Coordinate multiply(double multiplier)
	{
		return new Coordinate(x * multiplier, y * multiplier);
	}

	public double distanceFrom(Coordinate pos0, Coordinate pos1)
	{
		Coordinate difference = pos1.minus(pos0);
		Coordinate u = difference.unit();
		Coordinate x = minus(pos0);

		double d = x.dotProduct(u);

		if (d <= 0.0) return distanceFrom(pos0);
		if (d >= difference.length()) return distanceFrom(pos1);

		Coordinate projectionPoint = pos0.plus(u.multiply(d));

		return distanceFrom(projectionPoint);
	}

	public double dotProduct(Coordinate coordinate)
	{
		return x * coordinate.x + y * coordinate.y;
	}

	public Coordinate getNextPosition(double nextHeading, double nextVelocity, double angularVelocity)
	{
		double dX = nextVelocity * Math.sin(Math.toRadians(nextHeading + angularVelocity));
		double dY = nextVelocity * Math.cos(Math.toRadians(nextHeading + angularVelocity));
		return new Coordinate(x + dX, y + dY);

	}

	public double headingTo(Coordinate targetCoordinate)
	{
		Coordinate difference = targetCoordinate.minus(this);
		return Math.toDegrees(Math.atan2(difference.x, difference.y));
	}

	public Coordinate rotate(double angle_deg)
	{
		double angle_rad = -Math.toRadians(angle_deg); //due to the strange Coordinate system
		return new Coordinate
			(
				x * Math.cos(angle_rad) - y * Math.sin(angle_rad),
				x * Math.sin(angle_rad) + y * Math.cos(angle_rad)
			);
	}
	
	public String toString()
	{
		return "(" + (int)x + ", " + (int)y + ")";
	}
}

