
package sgp;

public class GravityIntercept extends LinearIntercept
{
	EnemyBattleState currentBattleState = null;
	
	EnemyGravityStrategy strategy = new EnemyGravityStrategy(StrategyManager.getInstance());
	
	Target target = null;

	final private int MAX_LOOKAHEAD = 150;
	
	/**
	 * Constructor for GravityIntercept.
	 */
	public GravityIntercept(Target theTarget)
	{
		super();
		target = theTarget;
		currentBattleState = new EnemyBattleState(target.robotBulletList);
	}

	/**
	 * Constructor for GravityIntercept.
	 * @param tRadius
	 */
	public GravityIntercept(double tRadius, Target theTarget)
	{
		super(tRadius);
		target = theTarget;
		currentBattleState = new EnemyBattleState(target.robotBulletList);
	}

	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		angularVelocity_rad_per_sec = Math.toRadians(angularVelocity_deg_per_sec);

		bulletStartingPoint.set(xb, yb);
		targetStartingPoint.set(xt, yt);

		targetHeading = tHeading;
		targetVelocity = vt;
		bulletPower = bPower;
		double vb = 20-3*bulletPower;

		impactTime = 0;
		double dX,dY;
		
		currentBattleState.enemyPosition.set(targetStartingPoint);
		currentBattleState.heading = targetHeading;
		currentBattleState.velocity = targetVelocity;
		currentBattleState.closestRobotPosition = target.closestRobotPosition;
		
		strategy.setBattleState(currentBattleState);

		impactPoint = getImpactPoint();
		impactTime = bulletStartingPoint.distanceFrom(impactPoint) / vb;

		dX = (impactPoint.x - bulletStartingPoint.x);
		dY = (impactPoint.y - bulletStartingPoint.y);

		distance = Math.sqrt(dX*dX+dY*dY);

		bulletHeading_deg = Math.toDegrees(Math.atan2(dX,dY));
		angleThreshold = Math.toDegrees(Math.atan(targetRadius/distance));
	}
	
	private Coordinate getImpactPoint()
	{
		EnemyBattleState battleState = currentBattleState;
		for (int t = 0; t < MAX_LOOKAHEAD; t++)
		{
			stepToNext(battleState);
			
			double enemyDistance = battleState.enemyPosition.distanceFrom(bulletStartingPoint);
			double bulletDistance = t * (20 - 3 * bulletPower);

			if (enemyDistance < (bulletDistance - targetRadius)) break;
		}
		
		return new Coordinate(battleState.enemyPosition);
	}
	
	private void stepToNext(EnemyBattleState battleState)
	{
		int bestIndex = strategy.getBestMovementIndex(battleState.enemyPosition, battleState.heading, battleState.velocity);
		battleState.step(strategy.nextPosition[bestIndex], 
			strategy.nextHeading[bestIndex], strategy.nextVelocity[bestIndex]);
	}
}
