
package sgp;
import robocode.*;

/**
 * Bullet fired by the robot
 */
public class RobotBullet 
{
	public Coordinate startingPosition = null;
	public Bullet bullet = null;
	public int type = -1;

	private double BULLET_TIME_INFLUENCE = 70;
	private double MAX_DISTANCE = 200;
	

	/**
	 * Constructor for RobotBullet.
	 */
	public RobotBullet(Coordinate startingPos, Bullet theBullet, int theType) 
	{
		startingPosition = startingPos;
		bullet = theBullet;
		type = theType;
	}
	
	public RobotBullet(Coordinate startingPos, Bullet theBullet) 
	{
		startingPosition = startingPos;
		bullet = theBullet;
	}
	
	
	public Coordinate getPosition()
	{
		return new Coordinate(bullet.getX(), bullet.getY());
	}
	
	public double distanceFrom(Coordinate position)
	{
		Coordinate p0 = getPosition();
		Coordinate dP = new Coordinate
		(
			bullet.getVelocity() * Math.sin(Math.toRadians(bullet.getHeading())) * BULLET_TIME_INFLUENCE,
			bullet.getVelocity() * Math.cos(Math.toRadians(bullet.getHeading())) * BULLET_TIME_INFLUENCE
		);
		Coordinate p1 = p0.plus(dP);

		double distance = position.distanceFrom(p0, p1);

		if (distance > MAX_DISTANCE) distance = MAX_DISTANCE;

		return distance;
	}

}
